/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.transformation.provider;

import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutorWrapper;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastBinariesExecutorWrapper;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;
import org.sing_group.seda.splign.transformation.dataset.SplignCompartPipelineSequencesGroupDatasetTransformation;
import org.sing_group.seda.splign.transformation.provider.SplignCompartPipelineTransformationConfigurationChangeType;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class SplignCompartPipelineTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private SplignCompartBinariesExecutor splignCompartBinariesExecutor;
    @XmlElement
    private BlastBinariesExecutorWrapper blastBinariesExecutor = new BlastBinariesExecutorWrapper();
    @XmlElement
    private BedToolsBinariesExecutorWrapper bedToolsBinariesExecutor = new BedToolsBinariesExecutorWrapper();
    @XmlElement
    private File queryFile;
    @XmlElement
    private boolean concatenateExons;

    @Override
    public Validation validate() {
        try {
            LinkedList<String> validationErrors = new LinkedList<String>();
            if (this.queryFile == null) {
                validationErrors.add("The query file can't be null");
            }
            if (!this.isValidSplignCompartBinariesExecutor()) {
                validationErrors.add("The Splign/Compart binaries executor is not valid");
            }
            if (!this.isValidBlastBinariesExecutor()) {
                validationErrors.add("The BLAST binaries executor is not valid");
            }
            if (!this.isValidBedToolsBinariesExecutor()) {
                validationErrors.add("The bedtools binaries executor is not valid");
            }
            if (validationErrors.isEmpty()) {
                this.getTransformation(DatatypeFactory.getDefaultDatatypeFactory());
                return new DefaultValidation(new String[0]);
            }
            return new DefaultValidation(validationErrors);
        }
        catch (RuntimeException ex) {
            return new DefaultValidation(ex.toString());
        }
    }

    private boolean isValidSplignCompartBinariesExecutor() {
        if (this.splignCompartBinariesExecutor == null) {
            return false;
        }
        try {
            this.splignCompartBinariesExecutor.checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    private boolean isValidBlastBinariesExecutor() {
        if (this.blastBinariesExecutor.get() == null) {
            return false;
        }
        try {
            this.blastBinariesExecutor.get().checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    private boolean isValidBedToolsBinariesExecutor() {
        if (this.bedToolsBinariesExecutor.get() == null) {
            return false;
        }
        try {
            this.bedToolsBinariesExecutor.get().checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return this.getProSplignCompartPipelineTransformation(factory);
    }

    private SplignCompartPipelineSequencesGroupDatasetTransformation getProSplignCompartPipelineTransformation(DatatypeFactory factory) {
        return new SplignCompartPipelineSequencesGroupDatasetTransformation(factory, this.splignCompartBinariesExecutor, this.bedToolsBinariesExecutor.get(), this.blastBinariesExecutor.get(), this.queryFile, this.concatenateExons);
    }

    public void setConcatenateExons(boolean concatenateExons) {
        if (this.concatenateExons != concatenateExons) {
            this.concatenateExons = concatenateExons;
            this.fireTransformationsConfigurationModelEvent(SplignCompartPipelineTransformationConfigurationChangeType.CONCATENATE_EXONS_CHANGED, this.concatenateExons);
        }
    }

    public boolean isConcatenateExons() {
        return this.concatenateExons;
    }

    public void setSplignCompartBinariesExecutor(Optional<SplignCompartBinariesExecutor> splignCompartBinariesExecutor) {
        this.splignCompartBinariesExecutor = splignCompartBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(SplignCompartPipelineTransformationConfigurationChangeType.SPLIGN_COMPART_EXECUTOR_CHANGED, this.splignCompartBinariesExecutor);
    }

    public SplignCompartBinariesExecutor getSplignCompartBinariesExecutor() {
        return this.splignCompartBinariesExecutor;
    }

    public void setBlastBinariesExecutor(Optional<BlastBinariesExecutor> blastBinariesExecutor) {
        this.blastBinariesExecutor.set((BlastBinariesExecutor)blastBinariesExecutor.orElse(null));
        this.fireTransformationsConfigurationModelEvent(SplignCompartPipelineTransformationConfigurationChangeType.BLAST_EXECUTOR_CHANGED, this.blastBinariesExecutor.get());
    }

    public BlastBinariesExecutor getBlastBinariesExecutor() {
        return this.blastBinariesExecutor.get();
    }

    public void setBedToolsBinariesExecutor(Optional<BedToolsBinariesExecutor> bedToolsBinariesExecutor) {
        this.bedToolsBinariesExecutor.set((BedToolsBinariesExecutor)bedToolsBinariesExecutor.orElse(null));
        this.fireTransformationsConfigurationModelEvent(SplignCompartPipelineTransformationConfigurationChangeType.BEDTOOLS_EXECUTOR_CHANGED, this.bedToolsBinariesExecutor);
    }

    public BedToolsBinariesExecutor getBedToolsBinariesExecutor() {
        return this.bedToolsBinariesExecutor.get();
    }

    public void clearQueryFile() {
        if (this.queryFile != null) {
            this.queryFile = null;
            this.fireTransformationsConfigurationModelEvent(SplignCompartPipelineTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.queryFile);
        }
    }

    public void setQueryFile(File queryFile) {
        if (this.queryFile == null || !this.queryFile.equals(queryFile)) {
            this.queryFile = queryFile;
            this.fireTransformationsConfigurationModelEvent(SplignCompartPipelineTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.queryFile);
        }
    }

    public File getQueryFile() {
        return this.queryFile;
    }
}

