/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.SplignCompartPipeline;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

public class SplignCompartPipelineSequencesGroupDatasetTransformation
implements SequencesGroupDatasetTransformation {
    private boolean concatenateExons;
    private File cdsQueryFasta;
    private final DatatypeFactory factory;
    private BlastBinariesExecutor blastBinariesExecutor;
    private BedToolsBinariesExecutor bedToolsBinariesExecutor;
    private SplignCompartBinariesExecutor splignCompartBinariesExecutor;

    public SplignCompartPipelineSequencesGroupDatasetTransformation(SplignCompartBinariesExecutor proSplignCompartBinariesExecutor, BedToolsBinariesExecutor bedToolsBinariesExecutor, BlastBinariesExecutor blastBinariesExecutor, File nucleotideFasta, boolean concatenateExons) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), proSplignCompartBinariesExecutor, bedToolsBinariesExecutor, blastBinariesExecutor, nucleotideFasta, concatenateExons);
    }

    public SplignCompartPipelineSequencesGroupDatasetTransformation(DatatypeFactory factory, SplignCompartBinariesExecutor proSplignCompartBinariesExecutor, BedToolsBinariesExecutor bedToolsBinariesExecutor, BlastBinariesExecutor blastBinariesExecutor, File genomeFasta, boolean concatenateExons) {
        this.splignCompartBinariesExecutor = proSplignCompartBinariesExecutor;
        this.blastBinariesExecutor = blastBinariesExecutor;
        this.bedToolsBinariesExecutor = bedToolsBinariesExecutor;
        this.factory = factory;
        this.cdsQueryFasta = genomeFasta;
        this.concatenateExons = concatenateExons;
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset sequencesGroupDataset) throws TransformationException {
        try {
            return this.runPipeline(sequencesGroupDataset, this.factory);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TransformationException("Error while running Splign/Compart. " + e.getMessage());
        }
    }

    private SequencesGroupDataset runPipeline(SequencesGroupDataset sequencesGroupDataset, DatatypeFactory factory) throws IOException, InterruptedException, ExecutionException {
        SplignCompartPipeline pipeline = new SplignCompartPipeline(this.bedToolsBinariesExecutor, this.splignCompartBinariesExecutor, this.blastBinariesExecutor, factory);
        LinkedList<SequencesGroup> results = new LinkedList<SequencesGroup>();
        try {
            for (SequencesGroup sequencesGroup : sequencesGroupDataset.getSequencesGroups().collect(Collectors.toList())) {
                Path targetFileFasta = Files.createTempFile(sequencesGroup.getName(), "fasta", new FileAttribute[0]);
                FastaWriter.writeFasta(targetFileFasta, sequencesGroup.getSequences());
                Path outputFasta = Files.createTempFile(sequencesGroup.getName() + "_splign_compart", ".fasta", new FileAttribute[0]);
                pipeline.splignCompart(targetFileFasta.toFile(), this.cdsQueryFasta, outputFasta.toFile(), this.concatenateExons);
                List<Sequence> alignedSequences = factory.newSequencesGroup(outputFasta).getSequences().collect(Collectors.toList());
                results.add(factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), alignedSequences));
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return factory.newSequencesGroupDataset(results.toArray(new SequencesGroup[results.size()]));
    }
}

