/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.execution;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.execution.AbstractBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.InputLineCallback;
import org.sing_group.seda.splign.execution.SplignCompartBinariesChecker;
import org.sing_group.seda.splign.execution.SplignCompartBinariesExecutor;

public abstract class AbstractSplignCompartBinariesExecutor
extends AbstractBinariesExecutor
implements SplignCompartBinariesExecutor {
    @Override
    public void checkBinary() throws BinaryCheckException {
        SplignCompartBinariesChecker.checkSplignCompartPath(this::composeCommand);
    }

    protected abstract String composeCommand(String var1);

    protected abstract String toFilePath(File var1);

    protected void mklds(List<String> splignCommand, File path) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(splignCommand);
        parameters.addAll(Arrays.asList("-mklds", this.toFilePath(path)));
        this.executeCommand(parameters);
    }

    protected void ldsdir(List<String> splignCommand, File ldsdir, File comps, File ldsdirFile) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(splignCommand);
        parameters.addAll(Arrays.asList("-ldsdir", this.toFilePath(ldsdir), "-comps", this.toFilePath(comps)));
        InputLineToFileCallback callBack = new InputLineToFileCallback(ldsdirFile);
        this.executeCommand(parameters, new File("."), callBack);
    }

    protected void compart(List<String> compartCommand, File qdb, File sdb, File compartmentsFile) throws IOException, InterruptedException {
        LinkedList<String> parameters = new LinkedList<String>(compartCommand);
        parameters.addAll(Arrays.asList("-qdb", this.toFilePath(qdb), "-sdb", this.toFilePath(sdb)));
        File workingDirectory = new File(this.toFilePath(qdb.getParentFile()));
        InputLineToFileCallback callBack = new InputLineToFileCallback(compartmentsFile);
        this.executeCommand(parameters, workingDirectory, callBack);
    }

    private static final class InputLineToFileCallback
    implements InputLineCallback {
        private final File file;
        private PrintWriter pw;

        public InputLineToFileCallback(File file) throws FileNotFoundException {
            this.file = file;
            this.pw = new PrintWriter(this.file);
        }

        @Override
        public void inputFinished() {
            if (this.pw != null) {
                this.pw.close();
            }
        }

        @Override
        public void inputStarted() {
        }

        @Override
        public void line(String line) {
            if (this.pw != null) {
                this.pw.println(line);
            }
        }

        @Override
        public void error(String message, Exception e) {
        }

        @Override
        public void info(String message) {
        }
    }
}

