/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.emboss.core.EmbossGetOrfSedaPluginInfo;
import org.sing_group.seda.emboss.getorf.gui.GetOrfTransformationConfigurationPanel;
import org.sing_group.seda.emboss.transformation.provider.GetOrfTransformationProvider;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class EmbossGetOrfSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private GetOrfTransformationConfigurationPanel embossConfigurationPanel = new GetOrfTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "getorf (EMBOSS)";
    }

    @Override
    public String getGroupName() {
        return EmbossGetOrfSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Find and extract all open reading frames (ORFs) with length longer than that specified by user, using the getorf program from the EMBOSS suite.";
    }

    @Override
    public Component getEditor() {
        return this.embossConfigurationPanel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.embossConfigurationPanel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<GetOrfTransformationProvider>().write(this.embossConfigurationPanel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.embossConfigurationPanel.setTransformationProvider((GetOrfTransformationProvider)new JsonObjectReader().read(file, GetOrfTransformationProvider.class));
    }
}

