/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.emboss.execution.DefaultEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.DockerEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.EmbossBinariesExecutor;
import org.sing_group.seda.emboss.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.emboss.gui.SystemBinaryExecutionConfigurationPanel;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class EmbossExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    private CardsPanel embossExecutableCardsPanel;
    private BinaryConfigurationPanelListener<EmbossBinariesExecutor> embossExecutorChanged;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;

    public EmbossExecutionConfigurationPanel(BinaryConfigurationPanelListener<EmbossBinariesExecutor> binaryConfigurationPanelListener) {
        this.embossExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.embossExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.embossExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty("seda.local.execution.enabled.emboss", "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.embossExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.embossExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::embossBinaryExecutorCardChanged);
        this.add((Component)this.embossExecutableCardsPanel);
    }

    private void embossBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.embossExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<EmbossBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<EmbossBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.embossExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(EmbossBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerEmbossBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSelectedDockerImage(((DockerEmbossBinariesExecutor)binariesExecutor).getDockerImage());
            this.embossExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultEmbossBinariesExecutor) {
            File directory = ((DefaultEmbossBinariesExecutor)binariesExecutor).getEmbossDirectory();
            if (directory != null) {
                this.systemBinaryExecutionConfigurationPanel.setSelectedFile(directory);
            } else {
                this.systemBinaryExecutionConfigurationPanel.clearSelectedFile();
            }
            this.embossExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown EmbossBinariesExecutor implementation");
        }
    }
}

