/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.getorf.cli;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.emboss.core.EmbossGetOrfSedaPluginInfo;
import org.sing_group.seda.emboss.execution.AbstractEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.DefaultEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.DockerEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.EmbossBinariesExecutor;
import org.sing_group.seda.emboss.getorf.datatype.FindParam;
import org.sing_group.seda.emboss.getorf.datatype.TableParam;
import org.sing_group.seda.emboss.transformation.provider.GetOrfTransformationProvider;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class GetOrfCommand
extends ExternalSoftwareExecutionCommand {
    public static final StringOption OPTION_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "docker-mode", "dk", "The EMBOSS docker image. By default, the official SEDA image for EMBOSS is used. If you provide a custom image, it should have the BLAST commands available in the path.", true, true);
    public static final StringOption OPTION_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "local-mode", "lc", "The directory that contains the EMBOSS binaries. Leave it empty if they are in the path.", true, true);
    public static final DefaultValuedStringOption OPTION_TABLE = new DefaultValuedStringOption("table", "t", EmbossGetOrfSedaPluginInfo.PARAM_TABLE_HELP, EmbossGetOrfSedaPluginInfo.DEFAULT_TABLE);
    public static final StringOption OPTION_FIND = new StringOption("find", "f", EmbossGetOrfSedaPluginInfo.PARAM_FIND_HELP, true, true);
    public static final DefaultValuedStringOption OPTION_MIN_SIZE = new DefaultValuedStringOption("min-size", "mis", "The minimum nucleotide size of ORF to report (any integer value).", Integer.toString(30));
    public static final DefaultValuedStringOption OPTION_MAX_SIZE = new DefaultValuedStringOption("max-size", "mas", "The maximum nucleotide size of ORF to report (any integer value).", Integer.toString(10000));
    public static final StringOption OPTION_ADDITIONAL_PARAMS = new StringOption("additional-params", "ad", "Additional parameters for the EMBOSS getorf command.", true, true);

    public String getName() {
        return "getorf";
    }

    public String getDescriptiveName() {
        return "getorf (EMBOSS)";
    }

    public String getDescription() {
        return "Find and extract all open reading frames (ORFs) with length longer than that specified by user, using the getorf program from the EMBOSS suite.";
    }

    @Override
    protected String getSedaGroup() {
        return EmbossGetOrfSedaPluginInfo.GROUP;
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return GetOrfCommand.fromKeyValue(OPTION_LOCAL_MODE, "seda.local.execution.enabled.emboss");
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_LOCAL_MODE);
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_LOCAL_MODE, OPTION_DOCKER_MODE, OPTION_TABLE, OPTION_FIND, OPTION_MIN_SIZE, OPTION_MAX_SIZE, OPTION_ADDITIONAL_PARAMS);
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_FIND);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        GetOrfTransformationProvider provider = new GetOrfTransformationProvider();
        provider.setFind(GetOrfCommand.getEnumValue(parameters, FindParam.class, OPTION_FIND));
        provider.setTable(GetOrfCommand.getEnumValue(parameters, TableParam.class, OPTION_TABLE));
        provider.setMinSize(this.getIntegerFromStringOption(parameters, (Option<String>)OPTION_MIN_SIZE));
        provider.setMaxSize(this.getIntegerFromStringOption(parameters, (Option<String>)OPTION_MAX_SIZE));
        Optional<String> additionalParameters = this.getAdditionalParameters(parameters);
        if (additionalParameters.isPresent()) {
            provider.setAdditionalParameters(additionalParameters.get());
        }
        provider.setEmbossBinariesExecutor(Optional.of(this.getEmbossBinariesExecutor(parameters)));
        return provider;
    }

    private EmbossBinariesExecutor getEmbossBinariesExecutor(Parameters parameters) {
        GetOrfCommand.validateSingleExecutionMode(parameters, OPTION_LOCAL_MODE, OPTION_DOCKER_MODE);
        AbstractEmbossBinariesExecutor executor = new DockerEmbossBinariesExecutor(DockerEmbossBinariesExecutor.getDefaultDockerImage());
        if (parameters.hasOption((Option)OPTION_LOCAL_MODE)) {
            File embossBinariesDirectory = new File(parameters.getSingleValueString((Option)OPTION_LOCAL_MODE));
            if (embossBinariesDirectory.isDirectory()) {
                executor = new DefaultEmbossBinariesExecutor(embossBinariesDirectory);
            } else {
                GetOrfCommand.formattedValidationError("The specified EMBOSS directory does not exist or it is not a directory.");
            }
        }
        if (parameters.hasOption((Option)OPTION_DOCKER_MODE)) {
            executor = new DockerEmbossBinariesExecutor((String)parameters.getSingleValue((Option)OPTION_DOCKER_MODE));
        }
        return executor;
    }

    private Optional<String> getAdditionalParameters(Parameters parameters) {
        if (!parameters.hasOption((Option)OPTION_ADDITIONAL_PARAMS)) {
            return Optional.empty();
        }
        return Optional.of((String)parameters.getSingleValue((Option)OPTION_ADDITIONAL_PARAMS));
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, GetOrfTransformationProvider.class);
    }
}

