/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.emboss.execution.AbstractEmbossBinariesExecutor;
import org.sing_group.seda.emboss.execution.EmbossEnvironment;

@XmlRootElement
public class DefaultEmbossBinariesExecutor
extends AbstractEmbossBinariesExecutor {
    @XmlTransient
    private final EmbossEnvironment emboss = EmbossEnvironment.getInstance();
    @XmlElement
    private final File embossDirectory;
    @XmlTransient
    private Optional<Path> directoryPath;

    public DefaultEmbossBinariesExecutor() {
        this(null);
    }

    public DefaultEmbossBinariesExecutor(File embossDirectory) {
        this.embossDirectory = embossDirectory;
    }

    private Optional<Path> getDirectoryPath() {
        if (this.directoryPath == null) {
            this.directoryPath = this.embossDirectory == null ? Optional.empty() : Optional.of(this.embossDirectory.toPath());
        }
        return this.directoryPath;
    }

    @Override
    public void getOrf(File input, File output, int table, int minSize, int maxSize, int find, String additionalEmbossParameters) throws IOException, InterruptedException {
        super.getOrf(Arrays.asList(this.composeEmbossCommand(this.emboss.getOrfCommand())), input, output, table, minSize, maxSize, find, additionalEmbossParameters);
    }

    @Override
    protected String composeEmbossCommand(String command) {
        return this.getDirectoryPath().map(path -> path.resolve(command)).orElse(Paths.get(command, new String[0])).toString();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public File getEmbossDirectory() {
        return this.embossDirectory;
    }
}

