/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.table.csv;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.plaf.UIResource;

public class BasicTransferable
implements Transferable,
UIResource {
    protected String plainData;
    protected String htmlData;
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;

    public BasicTransferable(String plainData, String htmlData) {
        this.plainData = plainData;
        this.htmlData = htmlData;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nRicher = richerFlavors != null ? richerFlavors.length : 0;
        int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
        int nString = this.isPlainSupported() ? stringFlavors.length : 0;
        int nFlavors = nRicher + nHTML + nPlain + nString;
        DataFlavor[] flavors = new DataFlavor[nFlavors];
        int nDone = 0;
        if (nRicher > 0) {
            System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
            nDone += nRicher;
        }
        if (nHTML > 0) {
            System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
            nDone += nHTML;
        }
        if (nPlain > 0) {
            System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
            nDone += nPlain;
        }
        if (nString > 0) {
            System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
            nDone += nString;
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isRicherFlavor(flavor)) {
            return this.getRicherData(flavor);
        }
        if (this.isHTMLFlavor(flavor)) {
            String data = this.getHTMLData();
            String string = data = data == null ? "" : data;
            if (String.class.equals(flavor.getRepresentationClass())) {
                return data;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new BufferedInputStream(new ByteArrayInputStream(data.getBytes()));
            }
        } else if (this.isPlainFlavor(flavor)) {
            String data = this.getPlainData();
            String string = data = data == null ? "" : data;
            if (String.class.equals(flavor.getRepresentationClass())) {
                return data;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new BufferedInputStream(new ByteArrayInputStream(data.getBytes()));
            }
        } else if (this.isStringFlavor(flavor)) {
            String data = this.getPlainData();
            data = data == null ? "" : data;
            return data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected boolean isRicherFlavor(DataFlavor flavor) {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
        for (int i = 0; i < nFlavors; ++i) {
            if (!richerFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor[] getRicherFlavors() {
        return null;
    }

    protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
        return null;
    }

    protected boolean isHTMLFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = htmlFlavors;
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHTMLSupported() {
        return this.htmlData != null;
    }

    protected String getHTMLData() {
        return this.htmlData;
    }

    protected boolean isPlainFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = plainFlavors;
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return this.plainData != null;
    }

    protected String getPlainData() {
        return this.plainData;
    }

    protected boolean isStringFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = stringFlavors;
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException cle) {
            System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
        }
    }
}

