/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.utilities;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public class MatrixUtils {
    public static double max(double[][] matrix) {
        return Stream.of(matrix).mapToDouble(MatrixUtils::max).max().getAsDouble();
    }

    public static double max(double[] array) {
        return Arrays.stream(array).filter(d -> !Double.isNaN(d)).max().getAsDouble();
    }

    public static double min(double[][] matrix) {
        return Stream.of(matrix).mapToDouble(MatrixUtils::min).min().getAsDouble();
    }

    public static double min(double[] array) {
        return Arrays.stream(array).filter(d -> !Double.isNaN(d)).min().getAsDouble();
    }

    public static double[][] transform(double[][] matrix, Function<Double, Double> transformation) {
        double[][] transformed = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            transformed[i] = DoubleStream.of(matrix[i]).map(transformation::apply).toArray();
        }
        return transformed;
    }

    public static double[][] center(double[][] matrix, BiFunction<double[], Boolean, Double> centering, boolean excludeNan) {
        double[][] centered = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            centered[i] = MatrixUtils.center(matrix[i], centering, excludeNan);
        }
        return centered;
    }

    private static double[] center(double[] data, BiFunction<double[], Boolean, Double> computeCenter, boolean excludeNan) {
        double center = computeCenter.apply(data, excludeNan);
        double[] centered = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            centered[i] = data[i] - center;
        }
        return centered;
    }

    public static double mean(double[] data, boolean excludeNan) {
        double sum = 0.0;
        if (excludeNan) {
            data = MatrixUtils.removeNan(data);
        }
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum / (double)data.length;
    }

    public static double median(double[] data, boolean excludeNan) {
        if (excludeNan) {
            data = MatrixUtils.removeNan(data);
        }
        Arrays.sort(data);
        double median = data.length % 2 == 0 ? (data[data.length / 2] + data[data.length / 2 - 1]) / 2.0 : data[data.length / 2];
        return median;
    }

    private static double[] removeNan(double[] data) {
        return DoubleStream.of(data).filter(d -> !Double.isNaN(d)).toArray();
    }

    public static Object[][] removeColumn(int column, Object[][] data) {
        if (column < 0 || column > data[0].length) {
            throw new IllegalArgumentException("Invalid column " + column);
        }
        Object[][] toret = new Object[data.length][data[0].length - 1];
        for (int i = 0; i < data.length; ++i) {
            int destCol = 0;
            for (int j = 0; j < data[i].length; ++j) {
                if (j == column) continue;
                toret[i][destCol++] = data[i][j];
            }
        }
        return toret;
    }

    public static String[][] asStringMatrix(Object[][] matrix) {
        String[][] toret = new String[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            toret[i] = (String[])Arrays.stream(matrix[i]).map(Object::toString).toArray(String[]::new);
        }
        return toret;
    }

    public static double[] asPrimitiveArray(List<Double> list) {
        double[] toret = new double[list.size()];
        for (int i = 0; i < toret.length; ++i) {
            toret[i] = list.get(i);
        }
        return toret;
    }
}

