/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.ui.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color color;
    private int width;
    private int height;

    public ColorIcon(Color color) {
        this(32, 32, color);
    }

    public ColorIcon(int width, int height, Color color) {
        this.width = width;
        this.height = height;
        this.color = color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 2);
        Insets insets = this.getInsets();
        int w = this.getIconWidth() - insets.left - insets.right;
        int h = this.getIconHeight() - insets.top - insets.bottom - 1;
        g.fillRect(x += insets.left, y += insets.top, w, h);
    }

    private Insets getInsets() {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

