/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.Orientation;
import org.sing_group.gc4s.utilities.ColorUtils;

public class IntegerRangeInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String MINIMUM_VALUE = "Minimum value";
    private static final String MAXIMUM_VALUE = "Maximum value";
    private int min;
    private int max;
    private int oldMinValue;
    private int oldMaxValue;
    private JLabel minValueLabel;
    private String minValueLabelText;
    private JIntegerTextField minValueTf;
    private JLabel maxValueLabel;
    private String maxValueLabelText;
    private JIntegerTextField maxValueTf;
    private int orientation;

    public IntegerRangeInputPanel(int min, int max) {
        this(min, max, MINIMUM_VALUE, MAXIMUM_VALUE);
    }

    public IntegerRangeInputPanel(int min, int max, String minLabel, String maxLabel) {
        this(min, max, minLabel, maxLabel, Orientation.VERTICAL);
    }

    public IntegerRangeInputPanel(int min, int max, String minLabel, String maxLabel, Orientation orientation) {
        this.min = min;
        this.max = max;
        this.minValueLabelText = minLabel;
        this.maxValueLabelText = maxLabel;
        this.orientation = orientation.getBoxLayoutOrientation();
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BoxLayout(this, this.orientation));
        this.add(this.getMinPanel());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.getMaxPanel());
        this.initializeTextFields();
    }

    private Component getMinPanel() {
        JPanel minPanel = new JPanel(new BorderLayout());
        minPanel.setLayout(new BoxLayout(minPanel, 0));
        this.minValueLabel = new JLabel(this.minValueLabelText);
        this.minValueTf = new JIntegerTextField((Integer)this.min);
        this.minValueTf.setColumns(6);
        minPanel.add(this.minValueLabel);
        minPanel.add(Box.createHorizontalStrut(5));
        minPanel.add(this.minValueTf);
        return minPanel;
    }

    private Component getMaxPanel() {
        JPanel maxPanel = new JPanel();
        maxPanel.setLayout(new BoxLayout(maxPanel, 0));
        this.maxValueLabel = new JLabel(this.maxValueLabelText);
        this.maxValueTf = new JIntegerTextField((Integer)this.max);
        this.maxValueTf.setColumns(6);
        maxPanel.add(this.maxValueLabel);
        maxPanel.add(Box.createHorizontalStrut(5));
        maxPanel.add(this.maxValueTf);
        return maxPanel;
    }

    private void initializeTextFields() {
        this.minValueTf.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                IntegerRangeInputPanel.this.rangeChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IntegerRangeInputPanel.this.rangeChanged();
            }
        });
        this.maxValueTf.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                IntegerRangeInputPanel.this.rangeChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IntegerRangeInputPanel.this.rangeChanged();
            }
        });
        this.oldMinValue = this.min;
        this.oldMaxValue = this.max;
    }

    public int getMinValue() {
        return this.minValueTf.getValue();
    }

    public void setMinValue(int min) {
        this.minValueTf.setText(String.valueOf(min));
    }

    public int getMaxValue() {
        return this.maxValueTf.getValue();
    }

    public void setMaxValue(int max) {
        this.maxValueTf.setText(String.valueOf(max));
    }

    private void rangeChanged() {
        if (this.rangeEffectivelyChanged()) {
            this.oldMinValue = this.getMinValue();
            this.oldMaxValue = this.getMaxValue();
            this.checkRange();
            Stream.of(this.getListeners(ChangeListener.class)).forEach(l -> l.stateChanged(new ChangeEvent(this)));
        }
    }

    private boolean rangeEffectivelyChanged() {
        return this.oldMinValue != this.getMinValue() || this.oldMaxValue != this.getMaxValue();
    }

    private void checkRange() {
        Color color = this.isValidRange() ? null : ColorUtils.COLOR_INVALID_INPUT;
        this.minValueTf.setBackground(color);
        this.maxValueTf.setBackground(color);
    }

    public boolean isValidRange() {
        return this.getMinValue() <= this.getMaxValue();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }
}

