/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.list;

import java.awt.Color;
import java.awt.Component;
import java.io.InvalidClassException;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataListener;
import org.sing_group.gc4s.input.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.input.list.JListPanel;
import org.sing_group.gc4s.ui.ColorListCellRenderer;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;

public class ColorsListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JList<Color> colorList;
    private JListPanel<Color> colorListPanel;
    private ExtendedDefaultListModel<Color> colorListModel;

    public ColorsListPanel() {
        this(Collections.emptyList());
    }

    public ColorsListPanel(List<Color> colors) {
        this.add(this.getColorListPanel(colors));
    }

    private Component getColorListPanel(List<Color> colors) {
        this.colorListModel = new ExtendedDefaultListModel();
        this.colorListModel.addElements(colors);
        this.colorList = new JList<Color>(this.colorListModel);
        this.colorList.setCellRenderer(new ColorListCellRenderer(){
            private static final long serialVersionUID = 1L;
            private final Border defaultBorder = new JButton().getBorder();

            @Override
            public Component getListCellRendererComponent(JList<? extends Color> list, Color value, int index, boolean isSelected, boolean cellHasFocus) {
                Component toret = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ((isSelected || cellHasFocus) && toret instanceof JComponent) {
                    ((JComponent)toret).setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 2));
                } else {
                    ((JComponent)toret).setBorder(this.defaultBorder);
                }
                return toret;
            }
        });
        try {
            this.colorListPanel = new JListPanel<Color>(this.colorList, true, false);
            this.colorListPanel.addAction(this.getAddColorAction(), "Adds a new color to the list");
            return this.colorListPanel;
        }
        catch (InvalidClassException e) {
            throw new RuntimeException("");
        }
    }

    private Action getAddColorAction() {
        return new ExtendedAbstractAction("Add color", Icons.ICON_ADD_16, this::addColorAction);
    }

    private void addColorAction() {
        new JColorChooser().setVisible(true);
        JColorChooser colorChooser = new JColorChooser();
        int response = JOptionPane.showConfirmDialog(this.getParent(), colorChooser, "Choose a color", 0);
        if (response == 0) {
            this.addColor(colorChooser.getSelectionModel().getSelectedColor());
        }
    }

    public void addColor(Color color) {
        SwingUtilities.invokeLater(() -> {
            this.colorListModel.addElement(color);
            this.colorList.updateUI();
        });
    }

    public void addColors(List<Color> colors) {
        SwingUtilities.invokeLater(() -> {
            this.colorListModel.addElements(colors);
            this.colorList.updateUI();
        });
    }

    public List<Color> getSelectedColors() {
        return Collections.list(this.colorListModel.elements());
    }

    public void addListDataListener(ListDataListener l) {
        this.colorListModel.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.colorListModel.removeListDataListener(l);
    }
}

