/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinition;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"id", "name", "request", "newRequest", "response", "uuid"})
@JsonIgnoreProperties(value={"$schema"})
public class StubMapping {
    public static final int DEFAULT_PRIORITY = 5;
    private UUID uuid = UUID.randomUUID();
    private String name;
    private Boolean persistent;
    private RequestPattern request;
    private ResponseDefinition response;
    private Integer priority;
    private String scenarioName;
    private String requiredScenarioState;
    private String newScenarioState;
    private List<PostServeActionDefinition> postServeActions;
    private Metadata metadata;
    private long insertionIndex;
    private boolean isDirty = true;
    public static final StubMapping NOT_CONFIGURED = new StubMapping(null, ResponseDefinition.notConfigured());

    public StubMapping(RequestPattern requestPattern, ResponseDefinition response) {
        this.setRequest(requestPattern);
        this.response = response;
    }

    public StubMapping() {
    }

    public static StubMapping buildFrom(String mappingSpecJson) {
        return Json.read(mappingSpecJson, StubMapping.class);
    }

    public static String buildJsonStringFor(StubMapping mapping) {
        return Json.write(mapping);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setId(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getId() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean shouldBePersisted() {
        return this.persistent != null && this.persistent != false;
    }

    public Boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public RequestPattern getRequest() {
        return (RequestPattern)MoreObjects.firstNonNull((Object)this.request, (Object)RequestPattern.ANYTHING);
    }

    public ResponseDefinition getResponse() {
        return (ResponseDefinition)MoreObjects.firstNonNull((Object)this.response, (Object)ResponseDefinition.ok());
    }

    public void setRequest(RequestPattern request) {
        this.request = request;
    }

    public void setResponse(ResponseDefinition response) {
        this.response = response;
    }

    public String toString() {
        return Json.write(this);
    }

    @JsonView(value={Json.PrivateView.class})
    public long getInsertionIndex() {
        return this.insertionIndex;
    }

    public void setInsertionIndex(long insertionIndex) {
        this.insertionIndex = insertionIndex;
    }

    @JsonIgnore
    public boolean isDirty() {
        return this.isDirty;
    }

    @JsonIgnore
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public String getRequiredScenarioState() {
        return this.requiredScenarioState;
    }

    public void setRequiredScenarioState(String requiredScenarioState) {
        this.requiredScenarioState = requiredScenarioState;
    }

    public String getNewScenarioState() {
        return this.newScenarioState;
    }

    public void setNewScenarioState(String newScenarioState) {
        this.newScenarioState = newScenarioState;
    }

    @JsonIgnore
    public boolean isInScenario() {
        return this.scenarioName != null;
    }

    @JsonIgnore
    public boolean modifiesScenarioState() {
        return this.newScenarioState != null;
    }

    @JsonIgnore
    public boolean isIndependentOfScenarioState() {
        return !this.isInScenario() || this.requiredScenarioState == null;
    }

    public int comparePriorityWith(StubMapping otherMapping) {
        int thisPriority = this.priority != null ? this.priority : 5;
        int otherPriority = otherMapping.priority != null ? otherMapping.priority : 5;
        return thisPriority - otherPriority;
    }

    public List<PostServeActionDefinition> getPostServeActions() {
        return this.postServeActions;
    }

    public void setPostServeActions(List<PostServeActionDefinition> postServeActions) {
        this.postServeActions = postServeActions;
    }

    @JsonProperty(value="postServeActions")
    public void setPostServeActions(Object postServeActions) {
        if (postServeActions == null) {
            return;
        }
        if (Map.class.isAssignableFrom(postServeActions.getClass())) {
            this.postServeActions = ((Map)postServeActions).entrySet().stream().map(entry -> new PostServeActionDefinition((String)entry.getKey(), Parameters.from((Map)entry.getValue()))).collect(Collectors.toList());
        } else if (List.class.isAssignableFrom(postServeActions.getClass())) {
            this.postServeActions = ((List)postServeActions).stream().map(item -> Json.mapToObject(item, PostServeActionDefinition.class)).collect(Collectors.toList());
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubMapping that = (StubMapping)o;
        return this.isDirty == that.isDirty && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.request, that.request) && Objects.equals(this.response, that.response) && Objects.equals(this.priority, that.priority) && Objects.equals(this.scenarioName, that.scenarioName) && Objects.equals(this.requiredScenarioState, that.requiredScenarioState) && Objects.equals(this.newScenarioState, that.newScenarioState) && Objects.equals(this.postServeActions, that.postServeActions) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.request, this.response, this.priority, this.scenarioName, this.requiredScenarioState, this.newScenarioState, this.postServeActions, this.metadata, this.isDirty);
    }
}

