/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.gui.BedToolsExecutionConfigurationPanel;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.gui.execution.SappExecutionConfigurationPanel;
import org.sing_group.seda.sapp.plugin.core.SappAnnotationSedaPluginInfo;
import org.sing_group.seda.sapp.transformation.provider.SappAnnotationTransformationProvider;

public class SappAnnotationTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SappAnnotationTransformationProvider transformationProvider;
    private JComboBox<SappCodon> codonCombobox;
    private JComboBox<SappSpecies> speciesCombobox;
    private SappExecutionConfigurationPanel sappExecutionConfigurationPanel;
    private BedToolsExecutionConfigurationPanel bedToolsExecutionConfigurationPanel;

    public SappAnnotationTransformationConfigurationPanel() {
        this.init();
        this.initTranformationProvider();
    }

    private void initTranformationProvider() {
        this.transformationProvider = new SappAnnotationTransformationProvider((SappSpecies)((Object)this.speciesCombobox.getSelectedItem()), (SappCodon)((Object)this.codonCombobox.getSelectedItem()));
        this.sappExecutorChanged();
        this.bedToolsExecutorChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getParametersPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getSappExecutableParameter());
        parameters.add(this.getBedToolsExecutableParameter());
        parameters.add(this.getSappSpeciesParameter());
        parameters.add(this.getSappCodonParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getSappExecutableParameter() {
        this.sappExecutionConfigurationPanel = new SappExecutionConfigurationPanel(this::sappExecutorChanged);
        this.sappExecutionConfigurationPanel.setBorder(BorderFactory.createTitledBorder("SAPP configuration"));
        return new InputParameter("", (JComponent)this.sappExecutionConfigurationPanel, "The mode to execute SAPP.");
    }

    private void sappExecutorChanged(BinaryExecutionConfigurationPanel<SappBinariesExecutor> source) {
        this.sappExecutorChanged();
    }

    private void sappExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setSappBinariesExecutor(this.sappExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getBedToolsExecutableParameter() {
        this.bedToolsExecutionConfigurationPanel = new BedToolsExecutionConfigurationPanel(this::bedToolsExecutorChanged);
        this.bedToolsExecutionConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("bedtools configuration"));
        return new InputParameter("", (JComponent)this.bedToolsExecutionConfigurationPanel, "The mode to execute bedtools.");
    }

    private void bedToolsExecutorChanged(BinaryExecutionConfigurationPanel<BedToolsBinariesExecutor> source) {
        this.bedToolsExecutorChanged();
    }

    private void bedToolsExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setBedToolsBinariesExecutor(this.bedToolsExecutionConfigurationPanel.getBinariesExecutor()));
    }

    public Optional<BedToolsBinariesExecutor> getBedToolsBinariesExecutor() {
        return this.bedToolsExecutionConfigurationPanel.getBinariesExecutor();
    }

    private InputParameter getSappSpeciesParameter() {
        this.speciesCombobox = new JComboBox<SappSpecies>(SappSpecies.values());
        this.speciesCombobox.addItemListener(this::sappSpeciesChanged);
        return new InputParameter("Species:", this.speciesCombobox, SappAnnotationSedaPluginInfo.PARAM_SAPP_SPECIES_HELP);
    }

    private void sappSpeciesChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setSappSpecies((SappSpecies)((Object)((Object)this.speciesCombobox.getSelectedItem()))));
        }
    }

    private InputParameter getSappCodonParameter() {
        this.codonCombobox = new JComboBox<SappCodon>(SappCodon.values());
        this.codonCombobox.addItemListener(this::codonChanged);
        return new InputParameter("Codon:", this.codonCombobox, SappAnnotationSedaPluginInfo.PARAM_CODON_HELP);
    }

    private void codonChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setSappCodon((SappCodon)((Object)((Object)this.codonCombobox.getSelectedItem()))));
        }
    }

    public SappAnnotationTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(SappAnnotationTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getSappCodon() != null) {
            this.codonCombobox.setSelectedItem((Object)this.transformationProvider.getSappCodon());
        }
        if (this.transformationProvider.getSappSpecies() != null) {
            this.speciesCombobox.setSelectedItem((Object)this.transformationProvider.getSappSpecies());
        }
        if (this.transformationProvider.getSappBinariesExecutor() != null) {
            this.sappExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getSappBinariesExecutor());
        }
        if (this.transformationProvider.getBedToolsBinariesExecutor() != null) {
            this.bedToolsExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getBedToolsBinariesExecutor());
        }
    }
}

