/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.commons.csv.io;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CsvWriter {
    private CsvFormat csvFormat;
    private Collector<CharSequence, ?, String> columnJoining;

    public static CsvWriter of(CsvFormat format) {
        Objects.requireNonNull(format, "CsvFormat can't be null");
        return new CsvWriter(format);
    }

    private CsvWriter(CsvFormat csvFormat) {
        this.csvFormat = csvFormat;
        this.init();
    }

    private void init() {
        this.columnJoining = Collectors.joining(this.csvFormat.getColumnSeparator());
    }

    public void write(Object[][] data, File file) throws IOException {
        this.write(this.toCsvData(data), file);
    }

    public void write(Object[][] data, List<String> header, File file) throws IOException {
        this.write(this.toCsvData(data), new CsvEntry((Collection<? extends String>)header), file);
    }

    private CsvData toCsvData(Object[][] data) {
        return CsvData.CsvDataBuilder.newCsvDataBuilder(this.csvFormat).withEntries(Stream.of(data).map(this::toCsvEntry).collect(Collectors.toList())).build();
    }

    private CsvEntry toCsvEntry(Object[] row) {
        return new CsvEntry(Stream.of(row).map(this::formatValue).collect(Collectors.toList()));
    }

    public void write(CsvData data, File file) throws IOException {
        this.write(data, data.getHeader(), file);
    }

    private void write(CsvData data, CsvEntry header, File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.writeHeader(sb, header);
        this.writeData(sb, data);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            writer.write(sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeHeader(StringBuilder sb, CsvEntry header) {
        if (!header.isEmpty()) {
            this.writeRow(sb, header);
        }
    }

    private void writeRow(StringBuilder sb, CsvEntry row) {
        sb.append(row.stream().map(this::csvField).collect(this.columnJoining)).append(this.getLineBreak());
    }

    private String csvField(String header) {
        if (this.isQuoteFields()) {
            return "\"" + header + "\"";
        }
        return header;
    }

    private boolean isQuoteFields() {
        return this.csvFormat.isQuoteFields();
    }

    private String getLineBreak() {
        return this.csvFormat.getLineBreak();
    }

    private void writeData(StringBuilder sb, CsvData data) {
        data.stream().forEach(row -> this.writeRow(sb, (CsvEntry)row));
    }

    private String formatValue(Object value) {
        if (value != null) {
            if (this.isDouble(value) || this.isFloat(value)) {
                if (this.isNaN(value)) {
                    return "";
                }
                return this.csvFormat.getDecimalFormatter().format(value);
            }
            return value.toString();
        }
        return "";
    }

    private boolean isNaN(Object value) {
        return this.isDouble(value) && Double.isNaN((Double)value) || this.isFloat(value) && Float.isNaN(((Float)value).floatValue());
    }

    private boolean isDouble(Object value) {
        return Double.class.isInstance(value) || Double.TYPE.isInstance(value);
    }

    private boolean isFloat(Object value) {
        return Float.class.isInstance(value) || Float.TYPE.isInstance(value);
    }
}

