/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.commons.csv.io;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CsvReader {
    private CsvFormat format;
    private boolean header = false;

    private CsvReader(CsvFormat format, boolean header) {
        this.format = format;
        this.header = header;
    }

    public CsvData read(File file) throws IOException {
        List<CsvEntry> entries = Files.readAllLines(file.toPath()).stream().map(this::csvEntry).collect(Collectors.toList());
        return this.csvData(entries);
    }

    private CsvData csvData(List<CsvEntry> entries) {
        CsvData.CsvDataBuilder csvDataBuilder = CsvData.CsvDataBuilder.newCsvDataBuilder(this.format);
        if (this.header) {
            csvDataBuilder.withHeader(entries.remove(0));
        }
        csvDataBuilder.withEntries(entries);
        return csvDataBuilder.build();
    }

    private boolean isQuoteFields() {
        return this.format.isQuoteFields();
    }

    public static String removeQuotes(String s) {
        int openingQuote = s.indexOf("\"");
        int closingQuote = s.lastIndexOf("\"");
        if (openingQuote == 0 && closingQuote > 0) {
            return s.substring(openingQuote + 1, closingQuote);
        }
        return s;
    }

    private CsvEntry csvEntry(String line) {
        return new CsvEntry(Arrays.asList(this.split(line)).stream().map(this::parseValue).collect(Collectors.toList()));
    }

    private String[] split(String line) {
        return line.concat(" ").split(this.getColumnSeparatorPattern());
    }

    private String getColumnSeparatorPattern() {
        return this.getColumnSeparator().concat("(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    }

    private String getColumnSeparator() {
        return this.format.getColumnSeparator();
    }

    private String parseValue(String s) {
        String toret = s.trim();
        if (this.isQuoteFields()) {
            return CsvReader.removeQuotes(toret);
        }
        return toret;
    }

    /* synthetic */ CsvReader(CsvFormat csvFormat, boolean bl, CsvReader csvReader) {
        this(csvFormat, bl);
    }

    public static class CsvReaderBuilder {
        private CsvFormat format;
        private boolean header = false;

        private CsvReaderBuilder() {
        }

        public static CsvReaderBuilder newCsvReaderBuilder() {
            return new CsvReaderBuilder();
        }

        public CsvReaderBuilder withFormat(CsvFormat format) {
            this.format = Objects.requireNonNull(format, "CsvFormat can't be null");
            return this;
        }

        public CsvReaderBuilder withHeader() {
            return this.withHeader(true);
        }

        public CsvReaderBuilder withHeader(boolean header) {
            this.header = header;
            return this;
        }

        public CsvReader build() {
            CsvReader instance = new CsvReader(this.format, this.header, null);
            return instance;
        }
    }
}

