/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.javaws.Main;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavawsConsoleController
implements ConsoleController {
    private ConsoleWindow console = null;
    private static JavawsConsoleController jcc = null;
    private static Logger logger = null;

    JavawsConsoleController() {
    }

    public static synchronized JavawsConsoleController getInstance() {
        if (jcc == null) {
            jcc = new JavawsConsoleController();
        }
        return jcc;
    }

    public void setConsole(ConsoleWindow consoleWindow) {
        if (this.console == null) {
            this.console = consoleWindow;
        }
    }

    public ConsoleWindow getConsole() {
        return this.console;
    }

    public boolean isIconifiedOnClose() {
        return false;
    }

    public boolean isDumpStackSupported() {
        return true;
    }

    public ThreadGroup getMainThreadGroup() {
        return Main.getSecurityThreadGroup().getParent();
    }

    public boolean isSecurityPolicyReloadSupported() {
        return true;
    }

    public void reloadSecurityPolicy() {
        Policy policy = Policy.getPolicy();
        policy.refresh();
    }

    public boolean isProxyConfigReloadSupported() {
        return true;
    }

    public void reloadProxyConfig() {
        DynamicProxyManager.reset();
    }

    public boolean isDumpClassLoaderSupported() {
        return false;
    }

    public String dumpClassLoaders() {
        return "Dump class loaders is unavailable.\n";
    }

    public boolean isClearClassLoaderSupported() {
        return false;
    }

    public void clearClassLoaders() {
    }

    public boolean isLoggingSupported() {
        return true;
    }

    public boolean toggleLogging() {
        if (logger != null) {
            Level level = logger.getLevel();
            level = level == Level.OFF ? Level.ALL : Level.OFF;
            logger.setLevel(level);
            return level == Level.ALL;
        }
        return false;
    }

    public void setLogger(Logger logger) {
        if (JavawsConsoleController.logger == null) {
            JavawsConsoleController.logger = logger;
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public boolean isJCovSupported() {
        return false;
    }

    public boolean dumpJCovData() {
        return false;
    }

    public String getProductName() {
        return ResourceManager.getString((String)"product.javaws.name", (String)"11.111.2.14");
    }

    public void notifyConsoleClosed() {
    }

    public void showConsoleIfEnabled() {
        if (Config.getStringProperty((String)"deployment.console.startup.mode").equals("SHOW") && this.console != null) {
            this.console.setVisible(true);
        }
    }

    public void setTitle(String string, String string2) {
        if (this.console != null) {
            this.console.setTitle(ResourceManager.getMessage((String)string) + string2);
        }
    }
}

