/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sing_group.seda.blast.BlastUtils;
import org.sing_group.seda.blast.datatype.SequenceType;
import org.sing_group.seda.blast.datatype.TwoWayBlastMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.util.OsUtils;

public class TwoWayBlastTransformation
implements SequencesGroupDatasetTransformation {
    public static final SequenceType DEFAULT_SEQUENCE_TYPE = SequenceType.NUCLEOTIDES;
    public static final BlastType DEFAULT_BLAST_TYPE = BlastType.BLASTN;
    public static final double DEFAULT_EVALUE = 0.05;
    public static final int DEFAULT_NUM_THREADS = 1;
    private BlastBinariesExecutor defaultBlastBinariesExecutor;
    private final TwoWayBlastMode mode;
    private final SequenceType databaseType;
    private final BlastType blastType;
    private final File databasesDirectory;
    private final double evalue;
    private DatatypeFactory factory;
    private File queryFile;
    private int numThreads;
    private final String blastAdditionalParameters;

    public TwoWayBlastTransformation(BlastType blastType, TwoWayBlastMode mode, BlastBinariesExecutor blastBinariesExecutor, File queryFile, File databasesPath, double evalue, String blastAdditionalParameters, int numThreads, DatatypeFactory factory) {
        this.databaseType = blastType.getDatabaseType();
        this.mode = mode;
        this.blastType = blastType;
        this.defaultBlastBinariesExecutor = blastBinariesExecutor;
        this.databasesDirectory = databasesPath;
        this.queryFile = queryFile;
        this.evalue = evalue;
        this.blastAdditionalParameters = blastAdditionalParameters;
        this.numThreads = numThreads;
        this.factory = factory;
        if (!this.isValidConfiguration()) {
            throw new RuntimeException("Invalid configuration");
        }
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) throws TransformationException {
        Objects.requireNonNull(dataset);
        return this.twoWayBlast(dataset);
    }

    private SequencesGroupDataset twoWayBlast(SequencesGroupDataset dataset) {
        SequencesGroup queryFasta = this.factory.newSequencesGroup(this.queryFile.toPath());
        Map<SequencesGroup, File> blastDatabases = null;
        try {
            blastDatabases = this.makeBlastDatabases(dataset, queryFasta, this.databasesDirectory);
        }
        catch (IOException | InterruptedException e) {
            throw new TransformationException("An error occurred while creating the databases");
        }
        try {
            return this.twoWayBlast(queryFasta, dataset, blastDatabases);
        }
        catch (Exception e) {
            throw new TransformationException("An error occurred while running BLAST");
        }
    }

    private Optional<String> extractFirstSubject(File blastResult) throws IOException {
        String[] split;
        Optional firstHit = Files.readAllLines(blastResult.toPath()).stream().findFirst();
        if (firstHit.isPresent() && (split = ((String)firstHit.get()).split("\t")).length > 1) {
            return Optional.of(split[1]);
        }
        return Optional.empty();
    }

    private Map<SequencesGroup, File> makeBlastDatabases(SequencesGroupDataset dataset, SequencesGroup queryFasta, File databasesDirectory) throws IOException, InterruptedException {
        HashMap<SequencesGroup, File> blastDatabases = new HashMap<SequencesGroup, File>();
        blastDatabases.put(queryFasta, this.makeBlastDatabase(queryFasta, databasesDirectory));
        for (SequencesGroup fasta : dataset.getSequencesGroups().collect(Collectors.toList())) {
            blastDatabases.put(fasta, this.makeBlastDatabase(fasta, databasesDirectory));
        }
        return blastDatabases;
    }

    private File makeBlastDatabase(SequencesGroup fasta, File databasesDirectory) throws IOException, InterruptedException {
        Path fastaFile = Files.createTempFile(fasta.getName(), "fasta", new FileAttribute[0]);
        FastaWriter.writeFasta(fastaFile, fasta.getSequences());
        File dbDirectory = new File(databasesDirectory, fasta.getName());
        dbDirectory.mkdir();
        File dbFile = new File(dbDirectory, fasta.getName());
        if (!BlastUtils.existDatabase(dbFile)) {
            this.makeblastdb(fastaFile.toFile(), dbFile);
        }
        fastaFile.toFile().delete();
        return dbFile;
    }

    private SequencesGroupDataset twoWayBlast(SequencesGroup queryFasta, SequencesGroupDataset dataset, Map<SequencesGroup, File> blastDatabases) throws Exception {
        File twoWayBlastTemporaryDir = Files.createTempDirectory("seda-two-way-blast", new FileAttribute[0]).toFile();
        LinkedList<SequencesGroup> sequencesGroups = new LinkedList<SequencesGroup>();
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        for (int i = 0; i < queryFasta.getSequenceCount(); ++i) {
            Sequence querySequence = queryFasta.getSequence(i);
            List<Sequence> sequenceOrtologs = Collections.synchronizedList(new LinkedList());
            sequenceOrtologs.add(querySequence);
            LinkedList<CompletableFuture<Void>> futures = new LinkedList<CompletableFuture<Void>>();
            List exceptions = Collections.synchronizedList(new LinkedList());
            for (SequencesGroup sequencesGroup : dataset.getSequencesGroups().collect(Collectors.toList())) {
                if (sequencesGroup.getName().equals(queryFasta.getName())) continue;
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    try {
                        sequenceOrtologs.addAll(this.twoWayBlast(querySequence, (File)blastDatabases.get(queryFasta), targetFasta, (File)blastDatabases.get(targetFasta), twoWayBlastTemporaryDir));
                    }
                    catch (IOException | InterruptedException e) {
                        exceptions.add(e);
                    }
                }, executorService);
                futures.add(future);
            }
            for (CompletableFuture completableFuture : futures) {
                while (!completableFuture.isDone()) {
                    TimeUnit.SECONDS.sleep(6L);
                }
            }
            if (!exceptions.isEmpty()) {
                executorService.shutdown();
                throw (Exception)exceptions.get(0);
            }
            sequencesGroups.add(this.factory.newSequencesGroup(this.getQuerySequenceName(querySequence), queryFasta.getProperties(), sequenceOrtologs));
        }
        executorService.shutdown();
        return this.factory.newSequencesGroupDataset(sequencesGroups.toArray(new SequencesGroup[sequencesGroups.size()]));
    }

    private List<Sequence> twoWayBlast(Sequence querySequence, File queryDatabase, SequencesGroup targetFasta, File targetDatabase, File twoWayBlastTemporaryDir) throws IOException, InterruptedException {
        LinkedList<Sequence> toret = new LinkedList<Sequence>();
        String querySequenceName = this.getQuerySequenceName(querySequence);
        Path temporaryDir = Files.createTempDirectory(twoWayBlastTemporaryDir.toPath(), querySequenceName + "_", new FileAttribute[0]);
        File querySequenceFile = Files.createTempFile(temporaryDir, querySequenceName, ".fasta", new FileAttribute[0]).toFile();
        FastaWriter.writeFasta(querySequenceFile.toPath(), querySequence);
        File blastAgainsTargetOutput = this.executeBlast(this.blastType, temporaryDir.toFile(), targetDatabase, querySequenceFile, this.evalue, 1, querySequenceName);
        Optional<String> firstSubject = this.extractFirstSubject(blastAgainsTargetOutput);
        if (firstSubject.isPresent()) {
            String firstSubjectName = firstSubject.get();
            File firstSubjectSequenceFile = Files.createTempFile(temporaryDir, firstSubjectName, ".fasta", new FileAttribute[0]).toFile();
            this.defaultBlastBinariesExecutor.blastDbCmd(targetDatabase, firstSubjectName, firstSubjectSequenceFile);
            File blatAgainstReferenceOutput = this.executeBlast(this.blastType, temporaryDir.toFile(), queryDatabase, firstSubjectSequenceFile, this.evalue, 1, firstSubjectName);
            Optional<String> firstQueryResult = this.extractFirstSubject(blatAgainstReferenceOutput);
            if (firstQueryResult.isPresent()) {
                String firstQueryResultName = firstQueryResult.get();
                File firstQueryResultSequenceFile = Files.createTempFile(temporaryDir, firstQueryResultName, ".fasta", new FileAttribute[0]).toFile();
                this.defaultBlastBinariesExecutor.blastDbCmd(queryDatabase, firstQueryResultName, firstQueryResultSequenceFile);
                if (firstQueryResultName.equals(querySequence.getName())) {
                    toret.add(this.getSequence(firstSubjectSequenceFile));
                } else if (this.mode.equals((Object)TwoWayBlastMode.NON_EXACT)) {
                    toret.add(this.getSequence(firstSubjectSequenceFile));
                    toret.add(this.getSequence(firstQueryResultSequenceFile));
                }
            }
        }
        return toret;
    }

    private Sequence getSequence(File firstSubjectSequenceFile) {
        return this.factory.newSequencesGroup(firstSubjectSequenceFile.toPath()).getSequences().findFirst().get();
    }

    private void makeblastdb(File inFile, File dbFile) throws IOException, InterruptedException {
        this.defaultBlastBinariesExecutor.makeBlastDb(inFile, this.getBlastSequenceType(), dbFile, true);
    }

    private String getQuerySequenceName(Sequence querySequence) {
        String name = querySequence.getName();
        for (String character : OsUtils.getInvalidOsFileCharacters()) {
            name.replace(character, "_");
        }
        return name;
    }

    private File executeBlast(BlastType blastType, File outDirectory, File database, File queryFile, double expectedValue, int maxTargetSeqs, String outputName) throws InterruptedException, IOException {
        File outFile = new File(outDirectory, outputName + ".out");
        if (!outDirectory.isDirectory() && !outDirectory.mkdirs()) {
            throw new IOException("Output directory could not be created: " + outDirectory);
        }
        List<String> additionalBlastParameters = this.getAdditionalBlastParameters();
        additionalBlastParameters.add("-max_hsps");
        additionalBlastParameters.add("1");
        this.defaultBlastBinariesExecutor.executeBlast(blastType, queryFile, database, expectedValue, maxTargetSeqs, outFile, "6", additionalBlastParameters);
        return outFile;
    }

    private List<String> getAdditionalBlastParameters() {
        if (this.blastAdditionalParameters != null && !this.blastAdditionalParameters.isEmpty()) {
            return new LinkedList<String>(Arrays.asList(this.blastAdditionalParameters.split(" ")));
        }
        return new LinkedList<String>();
    }

    private String getBlastSequenceType() {
        return this.databaseType.getBlastName();
    }

    private boolean isValidConfiguration() {
        try {
            this.defaultBlastBinariesExecutor.checkBinary();
        }
        catch (BinaryCheckException e) {
            return false;
        }
        if (this.getQueryFile() == null) {
            return false;
        }
        if (this.getDatabasesDirectory() == null) {
            return false;
        }
        return !this.getAdditionalBlastParameters().contains("-evalue") && !this.getAdditionalBlastParameters().contains("-max_target_seqs") && !this.getAdditionalBlastParameters().contains("-max_hsps");
    }

    private File getDatabasesDirectory() {
        return this.databasesDirectory;
    }

    private File getQueryFile() {
        return this.queryFile;
    }
}

