/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.plugin.core;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.sing_group.seda.blast.ncbi.NcbiBlastDatabase;
import org.sing_group.seda.blast.ncbi.NcbiBlastType;
import org.sing_group.seda.blast.ncbi.parameters.MatrixParameter;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.transformation.dataset.NcbiBlastTransformation;
import org.sing_group.seda.plugin.core.Group;
import org.sing_group.seda.plugin.core.info.AbstractInfo;

public class NcbiBlastSedaPluginInfo
extends AbstractInfo {
    public static final String NAME = "NCBI BLAST";
    public static final String SHORT_NAME = "blast-ncbi";
    public static final String DESCRIPTION = "Perform a BLAST query through the NCBI web server (https://blast.ncbi.nlm.nih.gov/Blast.cgi).";
    public static final String GROUP = Group.GROUP_BLAST.getName();
    public static final String PARAM_NCBI_BLAST_TYPE_NAME = "blast-type";
    public static final String PARAM_NCBI_BLAST_TYPE_SHORT_NAME = "bt";
    public static final String PARAM_NCBI_BLAST_TYPE_DESCRIPTION = "BLAST type";
    public static final String PARAM_NCBI_BLAST_TYPE_HELP_BASE = "The BLAST program to execute.";
    public static final String PARAM_NCBI_BLAST_TYPE_HELP = NcbiBlastSedaPluginInfo.shortEnumString("The BLAST program to execute.", NcbiBlastType.class);
    public static final String PARAM_NCBI_BLAST_TYPE_HELP_GUI = "The BLAST program to execute.";
    public static final String PARAM_NCBI_BLAST_DATABASE_NAME = "blast-database";
    public static final String PARAM_NCBI_BLAST_DATABASE_SHORT_NAME = "bd";
    public static final String PARAM_NCBI_BLAST_DATABASE_DESCRIPTION = "BLAST database";
    public static final String PARAM_NCBI_BLAST_DATABASE_HELP_BASE = "The NCBI database to run BLAST against.";
    public static final String PARAM_NCBI_BLAST_DATABASE_HELP = NcbiBlastSedaPluginInfo.longEnumStringForCli("The NCBI database to run BLAST against.", Arrays.stream(NcbiBlastDatabase.values()).collect(Collectors.toMap(NcbiBlastDatabase::getName, NcbiBlastDatabase::getTitle)));
    public static final String PARAM_NCBI_BLAST_DATABASE_HELP_GUI = "The NCBI database to run BLAST against.";
    public static final String PARAM_OUTPUT_TYPE_NAME = "output-type";
    public static final String PARAM_OUTPUT_TYPE_SHORT_NAME = "ot";
    public static final String PARAM_OUTPUT_TYPE_DESCRIPTION = "Output type";
    private static final String[] PARAM_OUTPUT_TYPE_HELP_ENUM = new String[]{"Creates a FASTA file with the complete sequences of each sequence that has an alignment against the query sequence.", "Creates a FASTA file with the portions of the sequences aligned against the query."};
    public static final String PARAM_OUTPUT_TYPE_HELP = NcbiBlastSedaPluginInfo.longEnumStringForCli("The output type.", NcbiBlastSedaPluginInfo.cliMap((Enum[])OutputTypeParameter.values(), (String[])PARAM_OUTPUT_TYPE_HELP_ENUM));
    public static final String PARAM_OUTPUT_TYPE_HELP_GUI = NcbiBlastSedaPluginInfo.toHtml(NcbiBlastSedaPluginInfo.longEnumStringForGui("The output type.", NcbiBlastSedaPluginInfo.guiMap((Enum[])OutputTypeParameter.values(), (String[])PARAM_OUTPUT_TYPE_HELP_ENUM)));
    public static final String PARAM_MATRIX_NAME = "matrix";
    public static final String PARAM_MATRIX_SHORT_NAME = "m";
    public static final String PARAM_MATRIX_DESCRIPTION = "Matrix";
    public static final String PARAM_MATRIX_HELP_BASE = "The scoring matrix to use.";
    public static final String PARAM_MATRIX_HELP = NcbiBlastSedaPluginInfo.shortEnumString("The scoring matrix to use.", MatrixParameter.class);
    public static final String PARAM_MATRIX_HELP_GUI = "The scoring matrix to use.";
    public static final String PARAM_FILTER_APPLY_NAME = "filter";
    public static final String PARAM_FILTER_APPLY_SHORT_NAME = "f";
    public static final String PARAM_FILTER_APPLY_DESCRIPTION = "Filter";
    public static final String PARAM_FILTER_APPLY_HELP = "Low complexity filtering.";
    public static final String PARAM_FILTER_APPLY_HELP_GUI = "Low complexity filtering.";
    public static final String PARAM_FILTER_LOOKUP_NAME = "filter-lookup";
    public static final String PARAM_FILTER_LOOKUP_SHORT_NAME = "fl";
    public static final String PARAM_FILTER_LOOKUP_DESCRIPTION = "Mask at lookup.";
    public static final String PARAM_FILTER_LOOKUP_HELP = "Mask at lookup when applying the low complexity filtering.";
    public static final String PARAM_EVALUE_NAME = "evalue";
    public static final String PARAM_EVALUE_SHORT_NAME = "ev";
    public static final String PARAM_EVALUE_DESCRIPTION = "Expectation value";
    public static final String PARAM_EVALUE_HELP = "The expectation value (E) threshold for saving hits.";
    public static final String PARAM_EVALUE_HELP_GUI = "The expectation value (E) threshold for saving hits.";
    public static final String PARAM_HITS_LIST_SIZE_NAME = "hits-list-size";
    public static final String PARAM_HITS_LIST_SIZE_SHORT_NAME = "hls";
    public static final String PARAM_HITS_LIST_SIZE_DESCRIPTION = "Hit list size";
    public static final String PARAM_HITS_LIST_SIZE_HELP = "Number of databases sequences to keep.";
    public static final String PARAM_HITS_LIST_SIZE_HELP_GUI = "Number of databases sequences to keep.";
    public static final String PARAM_WORD_SIZE_NAME = "word-size";
    public static final String PARAM_WORD_SIZE_SHORT_NAME = "ws";
    public static final String PARAM_WORD_SIZE_DESCRIPTION = "Word size";
    public static final String PARAM_WORD_SIZE_HELP = "Size of word for initial matches.";
    public static final String PARAM_WORD_SIZE_HELP_GUI = "Size of word for initial matches.";
    public static final String PARAM_THRESHOLD_NAME = "threshold";
    public static final String PARAM_THRESHOLD_SHORT_NAME = "th";
    public static final String PARAM_THRESHOLD_DESCRIPTION = "Threshold";
    public static final String PARAM_THRESHOLD_HELP = "Neighboring score for initial words. Does not apply to BLASTN or MegaBLAST.";
    public static final String PARAM_THRESHOLD_HELP_GUI = NcbiBlastSedaPluginInfo.toHtml("Neighboring score for initial words. Does not apply to BLASTN or MegaBLAST.");
    public static final OutputTypeParameter DEFAULT_OUTPUT_TYPE = NcbiBlastTransformation.DEFAULT_OUTPUT_TYPE_PARAMETER;
}

