/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi.parameters;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.blast.ncbi.parameters.NcbiBlastParameter;

@XmlRootElement
public class FilterParameter
implements NcbiBlastParameter {
    @XmlElement
    private boolean useFilter;
    @XmlElement
    private boolean maskAtLookup;

    public FilterParameter() {
        this(false);
    }

    public FilterParameter(boolean useFilter) {
        this(useFilter, false);
    }

    public FilterParameter(boolean useFilter, boolean maskAtLookup) {
        this.useFilter = useFilter;
        this.maskAtLookup = maskAtLookup;
    }

    @Override
    public String paramName() {
        return "FILTER";
    }

    @Override
    public String value() {
        if (!this.useFilter) {
            return "F";
        }
        return this.maskAtLookup ? "mL" : "T";
    }

    public boolean isUseFilter() {
        return this.useFilter;
    }

    public boolean isMaskAtLookup() {
        return this.maskAtLookup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maskAtLookup ? 1231 : 1237);
        result = 31 * result + (this.useFilter ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterParameter other = (FilterParameter)obj;
        if (this.maskAtLookup != other.maskAtLookup) {
            return false;
        }
        return this.useFilter == other.useFilter;
    }
}

