/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.execution;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class CgaCompiPipelineConfiguration {
    public static final int DEFAULT_MAX_DIST = 10000;
    public static final int DEFAULT_INTRON_BP = 100;
    public static final int DEFAULT_MIN_FULL_NUCLEOTIDE_SIZE = 100;
    public static final SelectionCriterion DEFAULT_SELECTION_CRITERION = SelectionCriterion.CRITERION_1;
    public static final int DEFAULT_SELECTION_CORRECTION = 0;
    public static final boolean DEFAULT_SKIP_PULL_DOCKER_IMAGES = false;
    @XmlElement
    private int maxDist = 10000;
    @XmlElement
    private int intronBp = 100;
    @XmlElement
    private int minFullNucleotideSize = 100;
    @XmlElement
    private SelectionCriterion selectionCriterion = DEFAULT_SELECTION_CRITERION;
    @XmlElement
    private int selectionCorrection = 0;
    @XmlElement
    private boolean skipPullDockerImages = false;

    public CgaCompiPipelineConfiguration() {
    }

    public CgaCompiPipelineConfiguration(int maxDist, int intronBp, int minFullNucleotideSize, SelectionCriterion selectionCriterion, int selectionCorrection, boolean skipPullDockerImages) {
        this.maxDist = maxDist;
        this.intronBp = intronBp;
        this.minFullNucleotideSize = minFullNucleotideSize;
        this.selectionCriterion = selectionCriterion;
        this.selectionCorrection = selectionCorrection;
        this.skipPullDockerImages = skipPullDockerImages;
    }

    public int getMaxDist() {
        return this.maxDist;
    }

    public int getIntronBp() {
        return this.intronBp;
    }

    public int getMinFullNucleotideSize() {
        return this.minFullNucleotideSize;
    }

    public SelectionCriterion getSelectionCriterion() {
        return this.selectionCriterion;
    }

    public int getSelectionCorrection() {
        return this.selectionCorrection;
    }

    public boolean isSkipPullDockerImages() {
        return this.skipPullDockerImages;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.intronBp, this.maxDist, this.minFullNucleotideSize, this.selectionCorrection, this.selectionCriterion, this.skipPullDockerImages});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CgaCompiPipelineConfiguration other = (CgaCompiPipelineConfiguration)obj;
        return this.intronBp == other.intronBp && this.maxDist == other.maxDist && this.minFullNucleotideSize == other.minFullNucleotideSize && this.selectionCorrection == other.selectionCorrection && this.selectionCriterion == other.selectionCriterion && this.skipPullDockerImages == other.skipPullDockerImages;
    }

    public static enum SelectionCriterion {
        CRITERION_1(1, "Similarity", "Similarity with reference sequence first, in case of a tie, percentage of gaps relative to reference sequence."),
        CRITERION_2(2, "Percentage of gaps", "Percentage of gaps relative to reference sequence first, in case of a tie, similarity with reference sequence."),
        CRITERION_3(3, "Mixed", "A mixed model with similarity with reference sequence first, but if fewer gaps relative to reference sequence similarity gets a bonus defined by the user. Currently, a bonus of 20, means 2%.");

        private int value;
        private String name;
        private String description;

        private SelectionCriterion(int value, String name, String description) {
            this.value = value;
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return String.join((CharSequence)". ", Integer.toString(this.value), this.name);
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

