/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.og;

import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.OgLineParser;
import uk.ac.ebi.uniprot.parser.antlr.OgLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.og.OgLineObject;

public class OgLineModelListener
extends OgLineParserBaseListener
implements ParseTreeObjectExtractor<OgLineObject> {
    private OgLineObject object;

    @Override
    public void enterOg_og(OgLineParser.Og_ogContext ctx) {
        this.object = new OgLineObject();
    }

    @Override
    public void exitPlasmid_name(OgLineParser.Plasmid_nameContext ctx) {
        Object targetObj;
        if (ctx.PLASMID_VALUE() != null) {
            String text = ctx.PLASMID_VALUE().getText();
            this.object.plasmidNames.add(text);
            targetObj = text;
        } else {
            this.object.ogs.add(OgLineObject.OgEnum.PLASMID);
            targetObj = OgLineObject.OgEnum.PLASMID;
        }
        OgLineParser.EvidenceContext evidence = ctx.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), targetObj, terminalNodes);
        }
    }

    @Override
    public void exitHydrogenosome_line(OgLineParser.Hydrogenosome_lineContext ctx) {
        this.object.ogs.add(OgLineObject.OgEnum.HYDROGENOSOME);
        OgLineParser.EvidenceContext evidence = ctx.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)OgLineObject.OgEnum.HYDROGENOSOME, terminalNodes);
        }
    }

    @Override
    public void exitNucleomorph_line(OgLineParser.Nucleomorph_lineContext ctx) {
        this.object.ogs.add(OgLineObject.OgEnum.NUCLEOMORPH);
        OgLineParser.EvidenceContext evidence = ctx.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)OgLineObject.OgEnum.NUCLEOMORPH, terminalNodes);
        }
    }

    @Override
    public void exitMitochondrion_line(OgLineParser.Mitochondrion_lineContext ctx) {
        this.object.ogs.add(OgLineObject.OgEnum.MITOCHONDRION);
        OgLineParser.EvidenceContext evidence = ctx.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)OgLineObject.OgEnum.MITOCHONDRION, terminalNodes);
        }
    }

    @Override
    public void exitPlastid_line(OgLineParser.Plastid_lineContext ctx) {
        OgLineParser.Plastid_nameContext plastidNameContext = ctx.plastid_name();
        OgLineObject.OgEnum og = null;
        if (plastidNameContext == null) {
            og = OgLineObject.OgEnum.PLASTID;
        } else if (plastidNameContext.APICOPLAST() != null) {
            og = OgLineObject.OgEnum.PLASTID_APICOPLAST;
        } else if (plastidNameContext.CYANELLE() != null) {
            og = OgLineObject.OgEnum.PLASTID_CYANELLE;
        } else if (plastidNameContext.ORGANELLAR_CHROMATOPHORE() != null) {
            og = OgLineObject.OgEnum.PLASTID_ORGANELLAR_CHROMATOPHORE;
        } else if (plastidNameContext.NON_PHOTOSYNTHETIC_PLASTID() != null) {
            og = OgLineObject.OgEnum.PLASTID_NON_PHOTOSYNTHETIC;
        } else if (plastidNameContext.CHLOROPLAST() != null) {
            og = OgLineObject.OgEnum.PLASTID_CHLOROPLAST;
        }
        this.object.ogs.add(og);
        OgLineParser.EvidenceContext evidence = ctx.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)og, terminalNodes);
        }
    }

    @Override
    public OgLineObject getObject() {
        return this.object;
    }
}

