/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.ft;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureId;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.parser.translator.FeatureTranslator;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.ft.FtLineObject;

public class FtLineConverter
extends EvidenceIdCollector
implements Converter<FtLineObject, List<Feature>> {
    private final FeatureFactory factory = DefaultFeatureFactory.getInstance();

    @Override
    public List<Feature> convert(FtLineObject f) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Map<Object, List<EvidenceId>> evidences = EvidenceHelper.convert(f.getEvidenceInfo());
        this.addAll(evidences.values());
        for (FtLineObject.FT ft : f.fts) {
            Object feature = this.factory.buildFeature(this.convert(ft.type));
            feature.setFeatureLocation(FeatureTranslator.createFeatureLocation(ft.locationStart, ft.locationEnd, ft.sequence));
            if (feature instanceof HasFeatureId && ft.ftId != null) {
                ((HasFeatureId)feature).setFeatureId(this.factory.buildFeatureId(ft.ftId));
            }
            if (!Strings.isNullOrEmpty((String)ft.ft_text)) {
                String text = ft.ft_text.trim();
                FeatureTranslator.updateFeatureDescription(feature, text);
            }
            EvidenceHelper.setEvidences(feature, evidences, ft);
            features.add((Feature)feature);
        }
        return features;
    }

    @Override
    private FeatureType convert(FtLineObject.FTType type) {
        FeatureType ftype = FeatureType.ACT_SITE;
        switch (type) {
            case INIT_MET: {
                ftype = FeatureType.INIT_MET;
                break;
            }
            case SIGNAL: {
                ftype = FeatureType.SIGNAL;
                break;
            }
            case PROPEP: {
                ftype = FeatureType.PROPEP;
                break;
            }
            case TRANSIT: {
                ftype = FeatureType.TRANSIT;
                break;
            }
            case CHAIN: {
                ftype = FeatureType.CHAIN;
                break;
            }
            case PEPTIDE: {
                ftype = FeatureType.PEPTIDE;
                break;
            }
            case TOPO_DOM: {
                ftype = FeatureType.TOPO_DOM;
                break;
            }
            case TRANSMEM: {
                ftype = FeatureType.TRANSMEM;
                break;
            }
            case INTRAMEM: {
                ftype = FeatureType.INTRAMEM;
                break;
            }
            case DOMAIN: {
                ftype = FeatureType.DOMAIN;
                break;
            }
            case REPEAT: {
                ftype = FeatureType.REPEAT;
                break;
            }
            case CA_BIND: {
                ftype = FeatureType.CA_BIND;
                break;
            }
            case ZN_FING: {
                ftype = FeatureType.ZN_FING;
                break;
            }
            case DNA_BIND: {
                ftype = FeatureType.DNA_BIND;
                break;
            }
            case NP_BIND: {
                ftype = FeatureType.NP_BIND;
                break;
            }
            case REGION: {
                ftype = FeatureType.REGION;
                break;
            }
            case COILED: {
                ftype = FeatureType.COILED;
                break;
            }
            case MOTIF: {
                ftype = FeatureType.MOTIF;
                break;
            }
            case COMPBIAS: {
                ftype = FeatureType.COMPBIAS;
                break;
            }
            case ACT_SITE: {
                ftype = FeatureType.ACT_SITE;
                break;
            }
            case METAL: {
                ftype = FeatureType.METAL;
                break;
            }
            case BINDING: {
                ftype = FeatureType.BINDING;
                break;
            }
            case SITE: {
                ftype = FeatureType.SITE;
                break;
            }
            case NON_STD: {
                ftype = FeatureType.NON_STD;
                break;
            }
            case MOD_RES: {
                ftype = FeatureType.MOD_RES;
                break;
            }
            case LIPID: {
                ftype = FeatureType.LIPID;
                break;
            }
            case CARBOHYD: {
                ftype = FeatureType.CARBOHYD;
                break;
            }
            case DISULFID: {
                ftype = FeatureType.DISULFID;
                break;
            }
            case CROSSLNK: {
                ftype = FeatureType.CROSSLNK;
                break;
            }
            case VAR_SEQ: {
                ftype = FeatureType.VAR_SEQ;
                break;
            }
            case VARIANT: {
                ftype = FeatureType.VARIANT;
                break;
            }
            case MUTAGEN: {
                ftype = FeatureType.MUTAGEN;
                break;
            }
            case UNSURE: {
                ftype = FeatureType.UNSURE;
                break;
            }
            case CONFLICT: {
                ftype = FeatureType.CONFLICT;
                break;
            }
            case NON_CONS: {
                ftype = FeatureType.NON_CONS;
                break;
            }
            case NON_TER: {
                ftype = FeatureType.NON_TER;
                break;
            }
            case HELIX: {
                ftype = FeatureType.HELIX;
                break;
            }
            case STRAND: {
                ftype = FeatureType.STRAND;
                break;
            }
            case TURN: {
                ftype = FeatureType.TURN;
            }
        }
        return ftype;
    }
}

