/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;

public final class DateUtils {
    private DateUtils() {
    }

    public static Date convertDateToUTCDate(Date date) {
        LocalDate localDate = DateUtils.convertDateToLocalDate(date, ZoneId.systemDefault());
        return DateUtils.convertLocalDateToDate(localDate, ZoneOffset.UTC);
    }

    public static Date convertLocalDateToDate(LocalDate localDate) {
        return DateUtils.convertLocalDateToDate(localDate, ZoneId.systemDefault());
    }

    private static Date convertLocalDateToDate(LocalDate localDate, ZoneId zoneId) {
        Instant instant = localDate.atStartOfDay(zoneId).toInstant();
        return Date.from(instant);
    }

    public static LocalDate convertDateToLocalDate(Date date) {
        return DateUtils.convertDateToLocalDate(date, ZoneId.systemDefault());
    }

    private static LocalDate convertDateToLocalDate(Date date, ZoneId zoneId) {
        return LocalDate.from(date.toInstant().atZone(zoneId));
    }
}

