/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.uniprot.dataservice.serializer.EntrySerializer;

public class DefaultEntrySerializer
implements EntrySerializer {
    private Logger logger = LoggerFactory.getLogger(DefaultEntrySerializer.class);
    private long counter_serialize = 0L;
    private long counter_deserialize = 0L;
    private long time_used_serialize = 0L;
    private long time_used_deserialize = 0L;

    @Override
    public byte[] serialize(UniProtEntry entry) {
        long l = System.nanoTime();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(entry);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            ++this.counter_serialize;
            this.time_used_serialize += System.nanoTime() - l;
            if (this.counter_serialize % 10000L == 0L) {
                this.logger.debug("{} entry is serialized in {} second", (Object)this.counter_serialize, (Object)(this.time_used_serialize / 1000000000L));
            }
            return bytes;
        }
        catch (IOException e) {
            this.logger.error("Error serialising BDB: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public UniProtEntry deserialize(byte[] bytes) {
        long l = System.nanoTime();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            UniProtEntry uniProtEntry = (UniProtEntry)objectInputStream.readObject();
            ++this.counter_deserialize;
            this.time_used_deserialize += System.nanoTime() - l;
            if (this.counter_deserialize % 10000L == 0L) {
                this.logger.debug("{} entry is deserialized in {} second", (Object)this.counter_deserialize, (Object)(this.time_used_deserialize / 1000000000L));
            }
            return uniProtEntry;
        }
        catch (IOException e) {
            this.logger.error("Error deserialising BDB: ", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Error deserialising BDB: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String deserializeToJSON(byte[] bytes) {
        throw new UnsupportedOperationException("Default Entry Serializer does not support JSON");
    }
}

