/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref;

import java.util.Date;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabase;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniref.AvroUniRefDb;

public class UniRefDBConverter
implements Converter<UniRefDatabase, AvroUniRefDb> {
    private final DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();

    @Override
    public AvroUniRefDb toAvro(UniRefDatabase u) {
        AvroUniRefDb.Builder builder = AvroUniRefDb.newBuilder();
        builder.setReleaseDate(u.getReleaseDate().getTime()).setType(u.getType().name()).setVersion(u.getUniRefVersion().getValue());
        return builder.build();
    }

    @Override
    public UniRefDatabase fromAvro(AvroUniRefDb a) {
        UniRefDatabase unirefDb = this.factory.buildUniRefDatabase();
        unirefDb.setReleaseDate(new Date(a.getReleaseDate()));
        unirefDb.setVersion(this.factory.buildUniRefDatabaseVersion(a.getVersion().toString()));
        unirefDb.setType(UniRefDatabaseType.typeOf(a.getType().toString()));
        return unirefDb;
    }
}

