/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.BookUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.DefaultCitationUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.JournalArticleUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.OnlineJournalArticleUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.PatentUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.SubmissionUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.ThesisUpdater;

public enum CitationUpdaterFactory {
    INSTANCE;

    private final JournalArticleUpdater jaUpdater = new JournalArticleUpdater();
    private final BookUpdater bookUpdater = new BookUpdater();
    private final OnlineJournalArticleUpdater onlineJaUpdater = new OnlineJournalArticleUpdater();
    private final PatentUpdater patentUpdater = new PatentUpdater();
    private final ThesisUpdater thesisUpdater = new ThesisUpdater();
    private final SubmissionUpdater submissionUpdater = new SubmissionUpdater();
    private final DefaultCitationUpdater defaultUpdater = new DefaultCitationUpdater();

    public CitationUpdater getUpdater(CitationTypeEnum type) {
        switch (type) {
            case BOOK: {
                return this.bookUpdater;
            }
            case JOURNAL_ARTICLE: {
                return this.jaUpdater;
            }
            case ELECTRONIC_ARTICLE: {
                return this.onlineJaUpdater;
            }
            case PATENT: {
                return this.patentUpdater;
            }
            case SUBMISSION: {
                return this.submissionUpdater;
            }
            case THESIS: {
                return this.thesisUpdater;
            }
        }
        return this.defaultUpdater;
    }
}

