/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.AssociationType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.DbXrefConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.feature.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.feature.AvroVariantAssociation;

public class VariantAssociationConverter
implements Converter<AssociationType, AvroVariantAssociation> {
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final DbXrefConverter xrefConverter = new DbXrefConverter();

    @Override
    public AvroVariantAssociation toAvro(AssociationType aType) {
        AvroVariantAssociation.Builder builder = AvroVariantAssociation.newBuilder();
        if (aType.getDescription() != null) {
            builder.setDescription(aType.getDescription());
        }
        if (aType.getName() != null) {
            builder.setName(aType.getName());
        }
        builder.setIsDisease(aType.isIsDisease());
        builder.setEvidences(aType.getEvidence().stream().map(this.evidenceConverter::toAvro).collect(Collectors.toList()));
        builder.setXrefs(aType.getXrefs().stream().map(this.xrefConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public AssociationType fromAvro(AvroVariantAssociation avro) {
        AssociationType aType = new AssociationType();
        if (avro.getDescription() != null) {
            aType.setDescription(avro.getDescription().toString());
        }
        if (avro.getName() != null) {
            aType.setName(avro.getName().toString());
        }
        aType.setIsDisease(avro.getIsDisease());
        avro.getEvidences().stream().map(this.evidenceConverter::fromAvro).forEach(aType.getEvidence()::add);
        avro.getXrefs().stream().map(this.xrefConverter::fromAvro).forEach(aType.getXrefs()::add);
        return aType;
    }
}

