/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.CommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.APCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.BPCPCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.CatalyticActivityCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.CofactorCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.DiseaseCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.InteractionCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.MassSpectrometryCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.RNAEditingCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.SequenceCautionCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.SubcellularLocationCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.TextOnlyCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.WebResourceCommentConverter;

public enum CommentConverterFactory {
    INSTANCE;

    private static TextOnlyCommentConverter textOnlyCommentConverter;
    private static APCommentConverter aPCommentConverter;
    private static BPCPCommentConverter bPCPCommentConverter;
    private static DiseaseCommentConverter diseaseCommentConverter;
    private static InteractionCommentConverter interactionCommentConverter;
    private static MassSpectrometryCommentConverter massSpectrometryCommentConverter;
    private static RNAEditingCommentConverter rnaEditingCommentConverter;
    private static SequenceCautionCommentConverter sequenceCautionCommentConverter;
    private static SubcellularLocationCommentConverter subcellularLocationCommentConverter;
    private static WebResourceCommentConverter webResourceCommentConverter;
    private static CofactorCommentConverter cofactorCommentConverter;
    private static CatalyticActivityCommentConverter catalyticActivityCommentConverter;

    public <T extends Comment> CommentConverter<T> getConverter(CommentType type) {
        switch (type) {
            case ALTERNATIVE_PRODUCTS: {
                return aPCommentConverter;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                return bPCPCommentConverter;
            }
            case DISEASE: {
                return diseaseCommentConverter;
            }
            case INTERACTION: {
                return interactionCommentConverter;
            }
            case MASS_SPECTROMETRY: {
                return massSpectrometryCommentConverter;
            }
            case RNA_EDITING: {
                return rnaEditingCommentConverter;
            }
            case SEQUENCE_CAUTION: {
                return sequenceCautionCommentConverter;
            }
            case SUBCELLULAR_LOCATION: {
                return subcellularLocationCommentConverter;
            }
            case COFACTOR: {
                return cofactorCommentConverter;
            }
            case WEBRESOURCE: {
                return webResourceCommentConverter;
            }
            case CATALYTIC_ACTIVITY: {
                return catalyticActivityCommentConverter;
            }
        }
        return textOnlyCommentConverter;
    }

    static {
        textOnlyCommentConverter = new TextOnlyCommentConverter();
        aPCommentConverter = new APCommentConverter();
        bPCPCommentConverter = new BPCPCommentConverter();
        diseaseCommentConverter = new DiseaseCommentConverter();
        interactionCommentConverter = new InteractionCommentConverter();
        massSpectrometryCommentConverter = new MassSpectrometryCommentConverter();
        rnaEditingCommentConverter = new RNAEditingCommentConverter();
        sequenceCautionCommentConverter = new SequenceCautionCommentConverter();
        subcellularLocationCommentConverter = new SubcellularLocationCommentConverter();
        webResourceCommentConverter = new WebResourceCommentConverter();
        cofactorCommentConverter = new CofactorCommentConverter();
        catalyticActivityCommentConverter = new CatalyticActivityCommentConverter();
    }
}

