/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.parser.impl.os.OrganismLineParserHelper;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.Host;

public class OrganismHostConverter
implements Converter<OrganismHost, Host> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();

    @Override
    public Host toAvro(OrganismHost oh) {
        Host.Builder builder = Host.newBuilder();
        builder.setName(this.toAvro(oh.getOrganism()));
        builder.setNcbiTaxId(oh.getNcbiTaxonomyId().getValue());
        return builder.build();
    }

    @Override
    public OrganismHost fromAvro(Host host) {
        OrganismHost oh = factory.buildOrganismHost();
        oh.setNcbiTaxonomyId(factory.buildNcbiTaxonomyId(host.getNcbiTaxId().toString()));
        oh.setOrganism(this.fromAvro(host.getName().toString()));
        return oh;
    }

    @Override
    private String toAvro(Organism organism) {
        StringBuilder sb = new StringBuilder();
        if (organism.getScientificName() != null) {
            sb.append(organism.getScientificName().getValue());
        }
        if (organism.getCommonName() != null && !organism.getCommonName().getValue().equals("")) {
            sb.append(" (");
            sb.append(organism.getCommonName().getValue());
            sb.append(")");
        }
        if (organism.getSynonym() != null && !organism.getSynonym().getValue().equals("")) {
            sb.append(" (");
            sb.append(organism.getSynonym());
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    private Organism fromAvro(String og) {
        return OrganismLineParserHelper.parse(og);
    }
}

