/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.query.impl;

import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.QueryFactory;
import uk.ac.ebi.uniprot.dataservice.query.impl.Accessor;
import uk.ac.ebi.uniprot.dataservice.query.impl.BasicQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.EmptyQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.MultivalueFieldPhraseQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.PhraseQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.QueryOp;
import uk.ac.ebi.uniprot.dataservice.query.impl.RangeQuery;

class DefaultQueryFactoryImpl
implements QueryFactory {
    DefaultQueryFactoryImpl() {
    }

    @Override
    public Query or(Query[] subQueries) {
        return QueryOp.or(subQueries);
    }

    @Override
    public Query and(Query[] subQueries) {
        return QueryOp.and(subQueries);
    }

    @Override
    public Query createPhraseQuery(String initField, String initValue, boolean negative) {
        return new PhraseQuery(initField, initValue, negative);
    }

    @Override
    public Query createBasicQuery(String initField, String initValue, boolean negative) {
        return new BasicQuery(initField, initValue, negative);
    }

    @Override
    public Query createRangeQuery(String field, String lower, boolean includeLow, String higher, boolean includeHigh) {
        return new RangeQuery(field, lower, includeLow, higher, includeHigh);
    }

    @Override
    public Query createMultiValuePhraseQuery(String initField, String initValue, boolean negative, int slop) {
        return new MultivalueFieldPhraseQuery(initField, initValue, negative, slop);
    }

    @Override
    public Query createEmptyQuery() {
        return EmptyQuery.getInstance();
    }

    static {
        Accessor.setDefault(new Accessor());
    }
}

