/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.domain.info.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObjectReader;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObjectWriter;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.RawInfoObjectImpl;

public class RawInfoObjectSerializer
implements RawInfoObjectReader,
RawInfoObjectWriter {
    private static final Logger logger = LoggerFactory.getLogger(RawInfoObjectSerializer.class);
    public static final String STATS_FILE = "STATS_FILE";
    private final String filePath;

    @Inject
    public RawInfoObjectSerializer(@Named(value="STATS_FILE") String filePath) {
        this.filePath = filePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<RawInfoObject> read() {
        Properties properties = new Properties();
        File f = new File(this.filePath);
        if (!f.exists() || f.isDirectory()) {
            logger.warn("InfoObject file doens't exist yet: {}", (Object)this.filePath);
            return Optional.empty();
        }
        try (FileInputStream fileInputStream = new FileInputStream(f);){
            properties.load(fileInputStream);
            RawInfoObjectImpl infoObject = new RawInfoObjectImpl(properties);
            Optional<RawInfoObject> optional = Optional.of(infoObject);
            return optional;
        }
        catch (IOException e) {
            logger.warn("Error while loading InfoObject file on path: " + this.filePath, (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean write(RawInfoObject rawInfoObject) {
        RawInfoObject toWrite = rawInfoObject;
        Optional<RawInfoObject> read = this.read();
        if (read.isPresent()) {
            RawInfoObject rawInfoObject1 = read.get();
            rawInfoObject1.storeInfo(rawInfoObject);
            toWrite = rawInfoObject1;
        }
        if (!(toWrite instanceof RawInfoObjectImpl)) throw new IllegalArgumentException("Not supported InfoObject type: " + rawInfoObject.getClass().getName());
        Map<String, String> rawMap = ((RawInfoObjectImpl)toWrite).getRawMap();
        Properties properties = new Properties();
        properties.putAll(rawMap);
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.filePath);){
            properties.store(fileOutputStream, null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.warn("Error while writing InfoObject file on path: " + this.filePath, (Throwable)e);
            return false;
        }
    }
}

