/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniref.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryId;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefComponent;

public class UniRefComponentImpl<T>
implements UniRefComponent<T> {
    private final UniRefEntryId uniRefEntryId;
    private final List<T> components;

    public UniRefComponentImpl(UniRefEntryId uniRefEntryId, List<T> components) {
        this.uniRefEntryId = uniRefEntryId;
        this.components = new ArrayList<T>();
        this.components.addAll(components);
    }

    public static <T> UniRefComponent<T> getInstance(String uniRefId, List<T> components) {
        UniRefEntryId uniRefEntryId = DefaultUniRefFactory.getInstance().buildUniRefEntryId(uniRefId);
        return new UniRefComponentImpl<T>(uniRefEntryId, components);
    }

    @Override
    public UniRefEntryId getUniRefEntryId() {
        return this.uniRefEntryId;
    }

    @Override
    public List<T> getComponent() {
        return this.components;
    }
}

