/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.impl.RequestResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.info.InfoService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.QuerySpec;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtData;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtField;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtServiceInfo;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.DefaultUniProtRequest;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.EntryResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.ResponseAdaptors;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.UniProtServiceInfoImpl;
import uk.ac.ebi.uniprot.dataservice.document.uniprot.UniProtDocument;
import uk.ac.ebi.uniprot.dataservice.domain.info.ServiceInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.UniProtServiceInfoObject;
import uk.ac.ebi.uniprot.dataservice.query.Query;

class UniProtServiceImpl
implements UniProtService {
    public static final String NAME_REMOTE_SERVER_URL = "UNIPROT_REMOTE_SERVER_URL";
    private final RequestResponseFactory factory;
    private final BasicService<Response<UniProtDocument>> service;
    private static final Logger logger = LoggerFactory.getLogger(UniProtServiceImpl.class);
    private int DEFAULT_COMPONENT_PAGE_SIZE = 100;
    private int DEFAULT_ENTRY_PAGE_SIZE = 100;
    private final InfoService infoService;

    @Inject
    public UniProtServiceImpl(RequestResponseFactory factory, @Named(value="UNIPROT_REMOTE_SERVER_URL") String serverURL, HttpRequestConfig serverConfig, InfoService infoService) {
        this.factory = factory;
        this.service = factory.createServiceForResponseType(serverURL, serverConfig, UniProtDocument.class);
        logger.info("UniProt Service is running against: {}", (Object)serverURL);
        this.infoService = infoService;
    }

    private boolean checkIsofromSpec(EnumSet<QuerySpec> specs) {
        return specs != null && specs.contains((Object)QuerySpec.WithIsoform);
    }

    @Override
    public QueryResult<UniProtEntry> getEntries(Query query, EnumSet<QuerySpec> spec) throws ServiceException {
        boolean withIsofrom = this.checkIsofromSpec(spec);
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setWithIsoform(withIsofrom);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.entryAdaptor);
    }

    @Override
    public QueryResult<UniProtEntry> getEntries(Query query, EnumSet<QuerySpec> spec, int offset, int pagesize) throws ServiceException {
        if (pagesize == -1) {
            return this.getEntries(query, spec);
        }
        boolean withIsofrom = this.checkIsofromSpec(spec);
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setWithIsoform(withIsofrom);
        uniProtRequest.setQuery(query);
        if (pagesize < 10000) {
            uniProtRequest.setCursorMark(null);
        }
        uniProtRequest.setResultCardinality(pagesize);
        uniProtRequest.setResultOffset(offset);
        uniProtRequest.setSort(UniProtField.Search.accession, false);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.entryAdaptor);
    }

    @Override
    public QueryResult<UniProtEntry> getEntries(Query query) throws ServiceException {
        return this.getEntries(query, null);
    }

    @Override
    public UniProtEntry getEntry(String accession) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setWithIsoform(true);
        Query request = UniProtQueryBuilder.accession(accession);
        uniProtRequest.setQuery(request);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        List<UniProtDocument> results = execute.getResults();
        if (results.size() > 0) {
            UniProtDocument uniprotDocument = results.get(0);
            return EntryResponseAdaptor.getInstance().adapt(uniprotDocument);
        }
        return null;
    }

    @Override
    public QueryResult<PrimaryUniProtAccession> getAccessions(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setFields(UniProtField.Return.accession);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.accessionAdaptor);
    }

    @Override
    public QueryResult<PrimaryUniProtAccession> getAccessions(Query query, EnumSet<QuerySpec> spec) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setFields(UniProtField.Return.accession);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        uniProtRequest.setWithIsoform(this.checkIsofromSpec(spec));
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.accessionAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Gene>> getGenes(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.geneAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<DatabaseCrossReference>> getXrefs(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.xrefAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<String>> getECNumbers(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.ecNumberAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<String>> getProteinNames(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.proteinNameAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Comment>> getComments(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.commentAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Feature>> getFeatures(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.featureAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Keyword>> getKeywords(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_COMPONENT_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.keywordAdaptor);
    }

    @Override
    public QueryResult<UniProtData> getResults(Query query, UniProtData.ComponentType ... componentTypes) throws ServiceException {
        return this.getResults(query, (EnumSet<QuerySpec>)null, componentTypes);
    }

    @Override
    public QueryResult<UniProtData> getResults(Query query, EnumSet<QuerySpec> specs, UniProtData.ComponentType ... componentTypes) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        boolean withIsofrom = this.checkIsofromSpec(specs);
        uniProtRequest.setWithIsoform(withIsofrom);
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return this.factory.createQueryResult(this.service, uniProtRequest, execute, ResponseAdaptors.UniProtDataAdaptor(componentTypes));
    }

    @Override
    public UniProtServiceInfo getServiceInfo() throws ServiceException {
        Optional<ServiceInfoObject> infoObj = this.infoService.getServiceInfo();
        if (infoObj.isPresent()) {
            UniProtServiceInfoObject uniInfoObj = infoObj.get().getUniProtServiceInfoObject();
            return new UniProtServiceInfoImpl(uniInfoObj.getReleaseNumber(), uniInfoObj.getTremblEntries(), uniInfoObj.getSwissProtEntries());
        }
        long siwssCount = this.getHitCount(UniProtQueryBuilder.swissprot());
        long tremblCount = this.getHitCount(UniProtQueryBuilder.trembl());
        return new UniProtServiceInfoImpl("", tremblCount, siwssCount);
    }

    public long getHitCount(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(this.factory.createRequest());
        uniProtRequest.setFields(UniProtField.Return.accession);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(0);
        Response<UniProtDocument> execute = this.service.execute(uniProtRequest);
        return execute.getHitCount();
    }

    @Override
    public void start() {
        this.service.start();
    }

    @Override
    public void stop() {
        this.service.stop();
    }

    @Override
    public boolean isStarted() {
        return this.service.isStarted();
    }
}

