/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtComponent;

class UniProtComponentImpl<T>
implements UniProtComponent<T> {
    private final PrimaryUniProtAccession accession;
    private final List<T> components;

    public UniProtComponentImpl(PrimaryUniProtAccession accession, List<T> components) {
        this.accession = accession;
        this.components = new ArrayList<T>();
        this.components.addAll(components);
    }

    public static <T> UniProtComponent<T> getInstance(String accession, List<T> components) {
        PrimaryUniProtAccession primaryUniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(accession);
        return new UniProtComponentImpl<T>(primaryUniProtAccession, components);
    }

    @Override
    public PrimaryUniProtAccession getAccession() {
        return this.accession;
    }

    @Override
    public List<T> getComponent() {
        return this.components;
    }
}

