/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtData;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EntryConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.entry.EntryObject;

class JapiUniProtResponseAdapter {
    static final GeneResponseAdaptor geneAdaptor = new GeneResponseAdaptor();
    static final XrefResponseAdaptor xrefAdaptor = new XrefResponseAdaptor();
    static final EcNumberResponseAdaptor ecNumberAdaptor = new EcNumberResponseAdaptor();
    static final ProteinNameResponseAdaptor proteinNameAdaptor = new ProteinNameResponseAdaptor();
    static final CommentResponseAdaptor commentAdaptor = new CommentResponseAdaptor();
    static final AccessionResponseAdaptor accessionAdaptor = new AccessionResponseAdaptor();
    static final FeatureResponseAdaptor featureAdaptor = new FeatureResponseAdaptor();
    static final KeywordResponseAdaptor keywordAdaptor = new KeywordResponseAdaptor();
    static final EntryResponseAdaptor entryAdaptor = new EntryResponseAdaptor();
    private static final EntryConverter converter = new EntryConverter();

    JapiUniProtResponseAdapter() {
    }

    public static final QueryResponseAdaptor JapiUniProtDataAdaptor(UniProtData.ComponentType[] types) {
        return new QueryResponseAdaptor(types);
    }

    private static List<Comment> convertComments(UniProtEntry entry) {
        return new ArrayList<Comment>(entry.getComments());
    }

    private static List<Gene> convertGenes(UniProtEntry entry) {
        return entry.getGenes();
    }

    private static List<Feature> convertFeatures(UniProtEntry entry) {
        return entry.getFeatures();
    }

    private static List<Keyword> convertKeywords(UniProtEntry entry) {
        return entry.getKeywords();
    }

    private static List<DatabaseCrossReference> convertXrefs(UniProtEntry entry) {
        return new ArrayList<DatabaseCrossReference>(entry.getDatabaseCrossReferences());
    }

    private static List<String> convertProteinName(UniProtEntry entry) {
        ProteinDescription proteinDescription = entry.getProteinDescription();
        Collection<Section> sections = JapiUniProtResponseAdapter.aggregateProteinNameSections(proteinDescription);
        return JapiUniProtResponseAdapter.extractNameValuesFromSections(sections, EnumSet.complementOf(EnumSet.of(FieldType.EC)));
    }

    private static List<String> convertEcNumber(UniProtEntry entry) {
        ProteinDescription proteinDescription = entry.getProteinDescription();
        Collection<Section> sections = JapiUniProtResponseAdapter.aggregateProteinNameSections(proteinDescription);
        return JapiUniProtResponseAdapter.extractNameValuesFromSections(sections, EnumSet.of(FieldType.EC));
    }

    private static Collection<Section> aggregateProteinNameSections(ProteinDescription proteinDescription) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (proteinDescription != null) {
            sections.add(proteinDescription.getSection());
            sections.addAll(proteinDescription.getIncludes());
            sections.addAll(proteinDescription.getContains());
        }
        return sections;
    }

    private static List<String> extractNameValuesFromSections(Collection<Section> sections, EnumSet<FieldType> fieldsToExtract) {
        List<String> extractedNames = new ArrayList<String>();
        if (sections != null) {
            extractedNames = sections.stream().map(Section::getNames).flatMap(Collection::stream).map(Name::getFields).flatMap(Collection::stream).filter(field -> fieldsToExtract.contains((Object)field.getType())).map(Value::getValue).collect(Collectors.toList());
        }
        return extractedNames;
    }

    static class UniProtComponentImpl<T>
    implements UniProtComponent<T> {
        private final PrimaryUniProtAccession accession;
        private final List<T> components;

        public UniProtComponentImpl(PrimaryUniProtAccession accession, List<T> components) {
            this.accession = accession;
            this.components = new ArrayList<T>();
            this.components.addAll(components);
        }

        public static <T> UniProtComponent<T> getInstance(String accession, List<T> components) {
            PrimaryUniProtAccession primaryUniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(accession);
            return new UniProtComponentImpl<T>(primaryUniProtAccession, components);
        }

        @Override
        public PrimaryUniProtAccession getAccession() {
            return this.accession;
        }

        @Override
        public List<T> getComponent() {
            return this.components;
        }
    }

    static class DefaultUniProtData
    implements UniProtData {
        private final EnumMap<UniProtData.ComponentType, Object> map = new EnumMap(UniProtData.ComponentType.class);
        private final PrimaryUniProtAccession accession;
        private final UniProtId id;

        DefaultUniProtData(PrimaryUniProtAccession accession, UniProtId id) {
            this.accession = accession;
            this.id = id;
        }

        @Override
        public PrimaryUniProtAccession getAccession() {
            return this.accession;
        }

        @Override
        public UniProtId getUniProtId() {
            return this.id;
        }

        @Override
        public boolean hasComponent(UniProtData.ComponentType type) {
            return this.map.containsKey((Object)type);
        }

        @Override
        public <T> T getComponent(UniProtData.ComponentType type) {
            return (T)this.map.get((Object)type);
        }

        public void put(UniProtData.ComponentType type, Object data) {
            this.map.put(type, data);
        }
    }

    static class AccessionResponseAdaptor
    implements ResponseAdaptor<PrimaryUniProtAccession, EntryObject> {
        AccessionResponseAdaptor() {
        }

        @Override
        public PrimaryUniProtAccession adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            return DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(entry.getPrimaryUniProtAccession().getValue());
        }
    }

    static class KeywordResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Keyword>, EntryObject> {
        KeywordResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Keyword> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List keywords = JapiUniProtResponseAdapter.convertKeywords(entry);
            return new UniProtComponentImpl<Keyword>(entry.getPrimaryUniProtAccession(), keywords);
        }
    }

    static class FeatureResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Feature>, EntryObject> {
        FeatureResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Feature> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List features = JapiUniProtResponseAdapter.convertFeatures(entry);
            return new UniProtComponentImpl<Feature>(entry.getPrimaryUniProtAccession(), features);
        }
    }

    static class CommentResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Comment>, EntryObject> {
        CommentResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Comment> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List comments = JapiUniProtResponseAdapter.convertComments(entry);
            return new UniProtComponentImpl<Comment>(entry.getPrimaryUniProtAccession(), comments);
        }
    }

    static class ProteinNameResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<String>, EntryObject> {
        ProteinNameResponseAdaptor() {
        }

        @Override
        public UniProtComponent<String> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List proteinNames = JapiUniProtResponseAdapter.convertProteinName(entry);
            return new UniProtComponentImpl<String>(entry.getPrimaryUniProtAccession(), proteinNames);
        }
    }

    static class EcNumberResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<String>, EntryObject> {
        EcNumberResponseAdaptor() {
        }

        @Override
        public UniProtComponent<String> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List ecNumbers = JapiUniProtResponseAdapter.convertEcNumber(entry);
            return new UniProtComponentImpl<String>(entry.getPrimaryUniProtAccession(), ecNumbers);
        }
    }

    static class XrefResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<DatabaseCrossReference>, EntryObject> {
        XrefResponseAdaptor() {
        }

        @Override
        public UniProtComponent<DatabaseCrossReference> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List results = JapiUniProtResponseAdapter.convertXrefs(entry);
            return new UniProtComponentImpl<DatabaseCrossReference>(entry.getPrimaryUniProtAccession(), results);
        }
    }

    static class GeneResponseAdaptor
    implements ResponseAdaptor<UniProtComponent<Gene>, EntryObject> {
        GeneResponseAdaptor() {
        }

        @Override
        public UniProtComponent<Gene> adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            List genes = JapiUniProtResponseAdapter.convertGenes(entry);
            return new UniProtComponentImpl<Gene>(entry.getPrimaryUniProtAccession(), genes);
        }
    }

    static class EntryResponseAdaptor
    implements ResponseAdaptor<UniProtEntry, EntryObject> {
        EntryResponseAdaptor() {
        }

        @Override
        public UniProtEntry adapt(EntryObject avroEntry) {
            return converter.fromAvro(avroEntry);
        }
    }

    public static class QueryResponseAdaptor
    implements ResponseAdaptor<UniProtData, EntryObject> {
        private final UniProtData.ComponentType[] types;

        public QueryResponseAdaptor(UniProtData.ComponentType[] types) {
            this.types = types;
        }

        @Override
        public UniProtData adapt(EntryObject avroEntry) {
            UniProtEntry entry = converter.fromAvro(avroEntry);
            PrimaryUniProtAccession acc = entry.getPrimaryUniProtAccession();
            UniProtId id = entry.getUniProtId();
            DefaultUniProtData data = new DefaultUniProtData(acc, id);
            for (UniProtData.ComponentType type : this.types) {
                Object obj = this.convert(entry, type);
                if (obj == null) continue;
                data.put(type, obj);
            }
            return data;
        }

        private Object convert(UniProtEntry entry, UniProtData.ComponentType type) {
            switch (type) {
                case COMMENTS: {
                    return JapiUniProtResponseAdapter.convertComments(entry);
                }
                case GENES: {
                    return entry.getGenes();
                }
                case FEATURES: {
                    return entry.getFeatures();
                }
                case KEYWORDS: {
                    return entry.getKeywords();
                }
                case ECNUMBER: {
                    return JapiUniProtResponseAdapter.convertEcNumber(entry);
                }
                case PROTEIN_NAMES: {
                    return JapiUniProtResponseAdapter.convertProteinName(entry);
                }
                case XREFS: {
                    return JapiUniProtResponseAdapter.convertXrefs(entry);
                }
                case TAXONOMY: {
                    return entry.getTaxonomy();
                }
            }
            return null;
        }
    }
}

