/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker;

import java.util.HashMap;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.ServiceCheckerMain;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.checkers.UniParcServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.checkers.UniProtServiceChecker;
import uk.ac.ebi.uniprot.dataservice.client.internal.servicechecker.checkers.UniRefServiceChecker;

public class ServiceCheckerFactory {
    private final ServiceFactory factory;

    public ServiceCheckerFactory(String serviceUrl) {
        if (serviceUrl != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("baseServiceURL", serviceUrl);
            this.factory = Client.getServiceFactoryInstance(map);
        } else {
            this.factory = Client.getServiceFactoryInstance();
        }
    }

    public ServiceChecker createServiceChecker(ServiceCheckerMain.ServiceEnum serviceEnum) {
        switch (serviceEnum) {
            case uniprot: {
                return new UniProtServiceChecker(this.factory.getUniProtQueryService());
            }
            case uniparc: {
                return new UniParcServiceChecker(this.factory.getUniParcQueryService());
            }
            case uniref: {
                return new UniRefServiceChecker(this.factory.getUniRefQueryService());
            }
        }
        return null;
    }
}

