/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.InternalBlastException;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.JobDispatcher;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.JobStatus;

class DispatcherSubmissionService<T, S> {
    private static final int JOB_POLL_INTERVAL = 2000;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobDispatcher<T, S> jobDispatcher;

    @Inject
    public DispatcherSubmissionService(JobDispatcher<T, S> jobDispatcher) {
        this.jobDispatcher = jobDispatcher;
    }

    public CompletableFuture<S> submitJob(T input) {
        return CompletableFuture.supplyAsync(() -> {
            this.logger.debug("Submitting blast job with input: [" + input.toString() + "]");
            String jobId = "Unknown";
            try {
                JobStatus status;
                jobId = this.jobDispatcher.submit(input);
                while ((status = this.jobDispatcher.checkStatus(jobId)) == JobStatus.RUNNING) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        throw new InternalBlastException("Blast job has been interrupted. Input: " + input.toString());
                    }
                }
                if (status != JobStatus.FINISHED) {
                    throw new InternalBlastException("Unexpected job status: " + (Object)((Object)status) + ", for blast job with input: " + input.toString());
                }
                this.logger.debug("Collecting blast result set from job: " + jobId);
                S ebiResult = this.jobDispatcher.getResult(jobId);
                if (ebiResult == null) {
                    throw new InternalBlastException("Blast result is null");
                }
                return ebiResult;
            }
            catch (InternalBlastException e) {
                this.logger.error("Blast error in job: {}, with input: {}", new Object[]{jobId, input.toString(), e});
                throw e;
            }
        });
    }
}

