/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.AlignmentCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.BlastVersionOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DropOffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ExpectationOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.MatrixOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ScoreCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.SequenceTypeOption;

public final class BlastInput {
    private Set<DatabaseOption> blastDatabases;
    private String sequence;
    private SequenceTypeOption sequenceType;
    private BlastVersionOption blastVersion;
    private MatrixOption matrix;
    private AlignmentCutoffOption alignmentCutoff;
    private ScoreCutoffOption scoreCutoff;
    private ExpectationOption expectation;
    private DropOffOption dropOff;
    private FilterOption filter;
    private boolean gapAlign;
    private int gapOpen;
    private int gapExt;
    private String seqRange;

    private BlastInput(Builder builder) {
        Preconditions.checkArgument((builder.blastDatabases.size() > 0 ? 1 : 0) != 0, (Object)"List of DatabaseOptions can not be empty");
        Preconditions.checkArgument((builder.sequence != null ? 1 : 0) != 0, (Object)"Sequence can not be null");
        Preconditions.checkArgument((builder.sequence.trim().length() > 0 ? 1 : 0) != 0, (Object)"Sequence can not be empty");
        Preconditions.checkArgument((builder.blastVersion != null ? 1 : 0) != 0, (Object)"Blast program can not be null");
        Preconditions.checkArgument((builder.sequenceType != null ? 1 : 0) != 0, (Object)"Blast sequence type not be null");
        Preconditions.checkArgument((builder.matrix != null ? 1 : 0) != 0, (Object)"Matrix scoring system can not be null");
        Preconditions.checkArgument((builder.alignmentCutoff != null ? 1 : 0) != 0, (Object)"Alignment cutoff can not be null");
        Preconditions.checkArgument((builder.scoreCutoff != null ? 1 : 0) != 0, (Object)"Score cutoff can not be null");
        Preconditions.checkArgument((builder.expectation != null ? 1 : 0) != 0, (Object)"Expectation can not be null");
        Preconditions.checkArgument((builder.dropOff != null ? 1 : 0) != 0, (Object)"Drop off can not be null");
        Preconditions.checkArgument((builder.gapOpen >= -1 && builder.gapOpen <= 21 ? 1 : 0) != 0, (Object)"Gap open value should be between [-1, 21]");
        Preconditions.checkArgument((builder.gapExt > 0 && builder.gapExt < 5 || builder.gapExt == -1 ? 1 : 0) != 0, (Object)"Gap extension value should be -1 or between [1, 4]");
        Preconditions.checkArgument((builder.seqRangeStart > 0 && builder.gapExt < 5 || builder.gapExt == -1 ? 1 : 0) != 0, (Object)"Gap extension value should be -1 or between [1, 4]");
        this.checkSeqRange(builder.seqRangeStart, builder.seqRangeStop, builder.sequence);
        this.blastDatabases = builder.blastDatabases;
        this.sequence = builder.sequence;
        this.sequenceType = builder.sequenceType;
        this.matrix = builder.matrix;
        this.blastVersion = builder.blastVersion;
        this.alignmentCutoff = builder.alignmentCutoff;
        this.scoreCutoff = builder.scoreCutoff;
        this.expectation = builder.expectation;
        this.dropOff = builder.dropOff;
        this.filter = builder.filter;
        this.gapAlign = builder.gapAlign;
        this.gapOpen = builder.gapOpen;
        this.gapExt = builder.gapExt;
        this.seqRange = this.buildSequenceRange(builder.seqRangeStart, builder.seqRangeStop);
    }

    private void checkSeqRange(int start, int end, String targetSequence) {
        if (start != -1 && start < 1) {
            throw new IllegalArgumentException("Start position of sequence range can not be less than 1");
        }
        if (end != -1 && end < 1) {
            throw new IllegalArgumentException("End position of sequence range can not be less than 1");
        }
        if (end < start) {
            throw new IllegalArgumentException("End position and not be less than start position in sequence range");
        }
        if (end > targetSequence.length()) {
            throw new IllegalArgumentException("End position in sequence range can not be greater than sequence submitted for blast");
        }
    }

    private String buildSequenceRange(int start, int end) {
        String seqRangText = null;
        if (start != -1 && end != -1) {
            seqRangText = start + "-" + end;
        }
        return seqRangText;
    }

    public Collection<DatabaseOption> getBlastDatabases() {
        return Collections.unmodifiableCollection(this.blastDatabases);
    }

    public String getSequence() {
        return this.sequence;
    }

    public SequenceTypeOption getSequenceType() {
        return this.sequenceType;
    }

    public BlastVersionOption getBlastVersion() {
        return this.blastVersion;
    }

    public MatrixOption getMatrix() {
        return this.matrix;
    }

    public AlignmentCutoffOption getAlignmentCutoff() {
        return this.alignmentCutoff;
    }

    public ScoreCutoffOption getScoreCutoff() {
        return this.scoreCutoff;
    }

    public ExpectationOption getExpectation() {
        return this.expectation;
    }

    public DropOffOption getDropOff() {
        return this.dropOff;
    }

    public FilterOption getFilter() {
        return this.filter;
    }

    public boolean hasGapAlign() {
        return this.gapAlign;
    }

    public int getGapOpen() {
        return this.gapOpen;
    }

    public int getGapExt() {
        return this.gapExt;
    }

    public String getSeqRange() {
        return this.seqRange;
    }

    public String toString() {
        return "BlastInput{blastDatabases=" + this.blastDatabases + ", sequence='" + this.sequence + '\'' + ", sequenceType=" + (Object)((Object)this.sequenceType) + ", blastVersion=" + (Object)((Object)this.blastVersion) + ", matrix=" + (Object)((Object)this.matrix) + ", alignmentCutoff=" + (Object)((Object)this.alignmentCutoff) + ", scoreCutoff=" + (Object)((Object)this.scoreCutoff) + ", expectation=" + (Object)((Object)this.expectation) + ", dropOff=" + (Object)((Object)this.dropOff) + ", filter=" + (Object)((Object)this.filter) + ", gapAlign=" + this.gapAlign + ", gapOpen=" + this.gapOpen + ", gapExt=" + this.gapExt + ", seqRange='" + this.seqRange + '\'' + '}';
    }

    public static class Builder {
        private Set<DatabaseOption> blastDatabases;
        private String sequence;
        private SequenceTypeOption sequenceType = SequenceTypeOption.PROTEIN;
        private BlastVersionOption blastVersion = BlastVersionOption.BLASTP;
        private MatrixOption matrix = MatrixOption.BLOSUM_62;
        private AlignmentCutoffOption alignmentCutoff = AlignmentCutoffOption.FIFTY;
        private ScoreCutoffOption scoreCutoff = ScoreCutoffOption.FIFTY;
        private ExpectationOption expectation = ExpectationOption.TEN;
        private DropOffOption dropOff = DropOffOption.ZERO;
        private FilterOption filter = null;
        private boolean gapAlign = true;
        private int gapOpen = -1;
        private int gapExt = -1;
        private int seqRangeStart = -1;
        private int seqRangeStop = -1;

        public Builder(DatabaseOption blastDatabase, String sequence) {
            this.blastDatabases = new HashSet<DatabaseOption>();
            this.blastDatabases.add(blastDatabase);
            this.sequence = sequence;
        }

        public Builder withSequenceType(SequenceTypeOption sequenceType) {
            this.sequenceType = sequenceType;
            return this;
        }

        public Builder usingBlastVersion(BlastVersionOption blastVersion) {
            this.blastVersion = blastVersion;
            return this;
        }

        public Builder withMatrix(MatrixOption matrix) {
            this.matrix = matrix;
            return this;
        }

        public Builder withMaximumNumberOfAlignments(AlignmentCutoffOption cutoff) {
            this.alignmentCutoff = cutoff;
            return this;
        }

        public Builder withMaximumNumberOfScores(ScoreCutoffOption cutoff) {
            this.scoreCutoff = cutoff;
            return this;
        }

        public Builder withExpectation(ExpectationOption expectation) {
            this.expectation = expectation;
            return this;
        }

        public Builder withDropOff(DropOffOption dropOff) {
            this.dropOff = dropOff;
            return this;
        }

        public Builder withFilter(FilterOption filter) {
            this.filter = filter;
            return this;
        }

        public Builder withGapAlign(boolean gapAlign) {
            this.gapAlign = gapAlign;
            return this;
        }

        public Builder withGapOpen(int gapOpen) {
            this.gapOpen = gapOpen;
            return this;
        }

        public Builder withGapExt(int gapExt) {
            this.gapExt = gapExt;
            return this;
        }

        public Builder withSequenceRange(int start, int stop) {
            this.seqRangeStart = start;
            this.seqRangeStop = stop;
            return this;
        }

        public Builder addDatabase(DatabaseOption database) {
            this.blastDatabases.add(database);
            return this;
        }

        public BlastInput build() {
            return new BlastInput(this);
        }
    }
}

