/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client;

import ch.qos.logback.classic.Level;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.ClientConfigurator;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.ClientGuiceModule;

public class Client {
    public static ServiceFactory getServiceFactoryInstance() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ClientGuiceModule()});
        Client.configLog(((ClientConfigurator)injector.getInstance(ClientConfigurator.class)).getLogLevel());
        ServiceFactory instance = (ServiceFactory)injector.getInstance(ServiceFactory.class);
        return instance;
    }

    public static ServiceFactory getServiceFactoryInstance(Map<String, String> config) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ClientGuiceModule(config)});
        Client.configLog(((ClientConfigurator)injector.getInstance(ClientConfigurator.class)).getLogLevel());
        ServiceFactory instance = (ServiceFactory)injector.getInstance(ServiceFactory.class);
        return instance;
    }

    private static void configLog(String logLevel) {
        if (logLevel != null && !logLevel.isEmpty()) {
            try {
                Level level = Level.valueOf((String)logLevel.toUpperCase());
                Logger logger = LoggerFactory.getLogger((String)"uk.ac.ebi.uniprot.dataservice.client");
                if (logger instanceof ch.qos.logback.classic.Logger) {
                    ch.qos.logback.classic.Logger japiLog = (ch.qos.logback.classic.Logger)logger;
                    japiLog.setLevel(level);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

