/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.annotation;

import uk.ac.ebi.uniprot.dataservice.document.Document;
import uk.ac.ebi.uniprot.dataservice.document.antigen.AntigenDocument;
import uk.ac.ebi.uniprot.dataservice.document.coordinate.GnCoordinateDocument;
import uk.ac.ebi.uniprot.dataservice.document.feature.FeatureDocument;
import uk.ac.ebi.uniprot.dataservice.document.proteome.ProteomeDocument;
import uk.ac.ebi.uniprot.dataservice.document.proteomics.ProteomicsDocument;
import uk.ac.ebi.uniprot.dataservice.document.uniparc.UniParcDocument;
import uk.ac.ebi.uniprot.dataservice.document.uniprot.UniProtDocument;
import uk.ac.ebi.uniprot.dataservice.document.uniref.UniRefDocument;

public enum DocumentTypeEnum {
    UNIPROT{

        @Override
        public Class<? extends Document> getDocumentType() {
            return UniProtDocument.class;
        }
    }
    ,
    UNIPARC{

        @Override
        public Class<? extends Document> getDocumentType() {
            return UniParcDocument.class;
        }
    }
    ,
    UNIREF{

        @Override
        public Class<? extends Document> getDocumentType() {
            return UniRefDocument.class;
        }
    }
    ,
    VARIATION{

        @Override
        public Class<? extends Document> getDocumentType() {
            return FeatureDocument.class;
        }
    }
    ,
    PROTEOMICS{

        @Override
        public Class<? extends Document> getDocumentType() {
            return ProteomicsDocument.class;
        }
    }
    ,
    ANTIGEN{

        @Override
        public Class<? extends Document> getDocumentType() {
            return AntigenDocument.class;
        }
    }
    ,
    GN_COORDINATE{

        @Override
        public Class<? extends Document> getDocumentType() {
            return GnCoordinateDocument.class;
        }
    }
    ,
    PROTEOME{

        @Override
        public Class<? extends Document> getDocumentType() {
            return ProteomeDocument.class;
        }
    };


    public abstract Class<? extends Document> getDocumentType();
}

