/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.xdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.xml.jaxb.xdb.Drlines;
import uk.ac.ebi.kraken.xml.xdb.DatabaseDef;
import uk.ac.ebi.kraken.xml.xdb.DatabaseDefContext;
import uk.ac.ebi.kraken.xml.xdb.DbCategory;
import uk.ac.ebi.kraken.xml.xdb.DbField;
import uk.ac.ebi.kraken.xml.xdb.DbFieldImpl;
import uk.ac.ebi.kraken.xml.xdb.UniProtXRefDBDef;

public class UniProtXRefDBDefCache
implements DatabaseDefContext {
    private static List<DatabaseDef> databaseDefs;
    private static Map<String, DatabaseDef> databaseType2Defs;
    private static boolean init;
    private static Map<String, DatabaseDef> databaseType2DefsNoCase;
    private static String DRLINE_CONF_FILE;
    private static List<String> allDBNames;
    private static String JAXB_CLASS_PACKAGE;
    private static UniProtXRefDBDefCache INSTANCE;

    public static synchronized UniProtXRefDBDefCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UniProtXRefDBDefCache();
        }
        return INSTANCE;
    }

    private UniProtXRefDBDefCache() {
        this.initCache();
    }

    private synchronized void initCache() {
        if (init) {
            return;
        }
        try {
            InputStream in = this.getFileAsStream(DRLINE_CONF_FILE);
            if (in == null) {
                System.err.println("could not open dr configuration file: " + DRLINE_CONF_FILE);
                return;
            }
            databaseDefs = new CopyOnWriteArrayList<DatabaseDef>();
            allDBNames = new CopyOnWriteArrayList<String>();
            databaseType2Defs = new ConcurrentHashMap<String, DatabaseDef>();
            databaseType2DefsNoCase = new ConcurrentHashMap<String, DatabaseDef>();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CLASS_PACKAGE);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Drlines drLines = (Drlines)unmarshaller.unmarshal(in);
            for (Drlines.DbCrossReference dbxref : drLines.getDbCrossReference()) {
                DatabaseDef xrefdbDef = this.convert(dbxref);
                databaseDefs.add(xrefdbDef);
                databaseType2Defs.put(xrefdbDef.getName(), xrefdbDef);
                String dbname = xrefdbDef.getName();
                databaseType2DefsNoCase.put(dbname.toUpperCase(), xrefdbDef);
            }
            Collections.sort(databaseDefs, new XRefDBOrder());
            for (DatabaseDef dbdef : databaseDefs) {
                allDBNames.add(dbdef.getName());
            }
            init = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private InputStream getFileAsStream(String filename) {
        try {
            InputStream in = UniProtXRefDBDefCache.class.getClassLoader().getResourceAsStream(filename);
            if (in != null) {
                return in;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File file = new File(filename);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private DatabaseDef convert(Drlines.DbCrossReference dbxref) {
        if (dbxref.getToName().equalsIgnoreCase("Go")) {
            return this.convertGo(dbxref);
        }
        List<Drlines.DbCrossReference.Property> properties = dbxref.getProperty();
        ArrayList<DbField> fields = new ArrayList<DbField>();
        DbField idField = null;
        for (Drlines.DbCrossReference.Property p : properties) {
            DbFieldImpl field = new DbFieldImpl(p.getName(), DbField.FieldType.INTERFACE, p.getLink(), p.getXmlTag());
            if (p.getName().equals(dbxref.getAccField())) {
                idField = field;
            }
            fields.add(field);
        }
        if (idField == null) {
            idField = (DbField)fields.get(0);
        }
        UniProtXRefDBDef xrefdbDef = new UniProtXRefDBDef(dbxref.getToName(), dbxref.getType(), dbxref.getToDisplayName(), DbCategory.getType(dbxref.getCategory()), idField, fields, dbxref.isDeprecated());
        return xrefdbDef;
    }

    private DatabaseDef convertGo(Drlines.DbCrossReference dbxref) {
        List<Drlines.DbCrossReference.Property> properties = dbxref.getProperty();
        ArrayList<DbField> fields = new ArrayList<DbField>();
        DbFieldImpl idField = null;
        for (Drlines.DbCrossReference.Property p : properties) {
            if (p.getType().equals("enum")) continue;
            DbFieldImpl field = new DbFieldImpl(p.getName(), DbField.FieldType.INTERFACE, p.getLink(), p.getXmlTag());
            if (dbxref.getAccField().equals(p.getName())) {
                idField = field;
            }
            fields.add(field);
        }
        UniProtXRefDBDef xrefdbDef = new UniProtXRefDBDef(dbxref.getToName(), dbxref.getType(), dbxref.getToDisplayName(), DbCategory.getType(dbxref.getCategory()), idField, fields, dbxref.isDeprecated());
        return xrefdbDef;
    }

    @Override
    public DatabaseDef getXRefDBDef(String db) {
        DatabaseDef dbdef = databaseType2Defs.get(db);
        if (dbdef == null) {
            dbdef = databaseType2DefsNoCase.get(db.toUpperCase());
        }
        return dbdef;
    }

    @Override
    public DatabaseDef getXRefDBDef(DatabaseType type) {
        return this.getXRefDBDef(type.getName());
    }

    @Override
    public List<DatabaseDef> getAllXRefDBDefs() {
        return databaseDefs;
    }

    @Override
    public List<String> getAllXrefDBName() {
        return allDBNames;
    }

    static {
        DRLINE_CONF_FILE = "conf/drlineconfiguration.xml";
        allDBNames = null;
        JAXB_CLASS_PACKAGE = "uk.ac.ebi.kraken.xml.jaxb.xdb";
        INSTANCE = null;
    }

    private static class XRefDBOrder
    implements Comparator<DatabaseDef> {
        public static final List<DatabaseType> orderDatabases = DatabaseType.getOrderedValues();

        private XRefDBOrder() {
        }

        @Override
        public int compare(DatabaseDef o1, DatabaseDef o2) {
            return this.getLocation(o1) - this.getLocation(o2);
        }

        private int getLocation(DatabaseDef dd) {
            String name = dd.getName();
            for (int i = 0; i < orderDatabases.size(); ++i) {
                if (!orderDatabases.get(i).getName().equalsIgnoreCase(name)) continue;
                return i;
            }
            return 9999;
        }
    }
}

