/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import javax.xml.datatype.XMLGregorianCalendar;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabase;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.common.XMLGregorianCalendarConverter;
import uk.ac.ebi.kraken.xml.uniref.UniRefXmlDatabase;

public class UniRefDatabaseHandler
implements GenericHandler<UniRefDatabase, UniRefXmlDatabase> {
    private final UniRefFactory krakenFactory = DefaultUniRefFactory.getInstance();

    @Override
    public UniRefDatabase fromXmlBinding(UniRefXmlDatabase xmlObject) {
        UniRefDatabase krakenDB = this.krakenFactory.buildUniRefDatabase();
        if (xmlObject.getVersion() != null) {
            krakenDB.setVersion(this.krakenFactory.buildUniRefDatabaseVersion(xmlObject.getVersion()));
        }
        if (xmlObject.getReleaseDate() != null) {
            krakenDB.setReleaseDate(XMLGregorianCalendarConverter.asDate(xmlObject.getReleaseDate()));
        }
        krakenDB.setType(xmlObject.getDatabaseType());
        return krakenDB;
    }

    @Override
    public UniRefXmlDatabase toXmlBinding(UniRefDatabase object) {
        XMLGregorianCalendar releaseDate = XMLGregorianCalendarConverter.asXMLGregorianCalendar(object.getReleaseDate());
        return new UniRefXmlDatabase(object.getType(), releaseDate, object.getUniRefVersion().getValue());
    }
}

