/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import com.google.common.base.Strings;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.exceptions.FieldUnavailableException;
import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.common.XMLParserException;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.LocationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PositionType;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;

public class LocationHandlerStrategy
implements FeatureHandlerStrategy<Feature> {
    private final FeatureFactory featureFactory;
    private final ObjectFactory xmlUniprotFactory;
    private static final Logger LOG = LoggerFactory.getLogger(LocationHandlerStrategy.class);

    public LocationHandlerStrategy() {
        this(DefaultUniProtFactory.getFeatureFactory(), new ObjectFactory());
    }

    public LocationHandlerStrategy(FeatureFactory featureFactory, ObjectFactory xmlUniprotFactory) {
        this.featureFactory = featureFactory;
        this.xmlUniprotFactory = xmlUniprotFactory;
    }

    @Override
    public void featureFromXmlBinding(Feature feature, FeatureType xmlFeature) {
        FeatureLocation featureLocation;
        FeatureLocationModifier startLocationModifier = FeatureLocationModifier.UNKOWN;
        int startPosition = -1;
        FeatureLocationModifier endLocationModifier = FeatureLocationModifier.UNKOWN;
        int endPosition = -1;
        LocationType xmlLocation = xmlFeature.getLocation();
        if (xmlLocation.getPosition() != null) {
            startPosition = this.getPosition(xmlLocation.getPosition());
            startLocationModifier = this.getLocationModifier(xmlLocation.getPosition());
            endPosition = startPosition;
            endLocationModifier = startLocationModifier;
        } else if (xmlLocation.getBegin() != null && xmlLocation.getEnd() != null) {
            startPosition = this.getPosition(xmlLocation.getBegin());
            startLocationModifier = this.getLocationModifier(xmlLocation.getBegin());
            endPosition = this.getPosition(xmlLocation.getEnd());
            endLocationModifier = this.getLocationModifier(xmlLocation.getEnd());
        }
        if (!startLocationModifier.equals((Object)FeatureLocationModifier.UNKOWN) && !endLocationModifier.equals((Object)FeatureLocationModifier.UNKOWN)) {
            featureLocation = this.featureFactory.buildFeatureLocation(startPosition, startLocationModifier, endPosition, endLocationModifier);
        } else if (startLocationModifier.equals((Object)FeatureLocationModifier.UNKOWN) && !endLocationModifier.equals((Object)FeatureLocationModifier.UNKOWN)) {
            featureLocation = this.featureFactory.buildFeatureLocationWithUnknownStart(endPosition, endLocationModifier);
        } else if (!startLocationModifier.equals((Object)FeatureLocationModifier.UNKOWN) && endLocationModifier.equals((Object)FeatureLocationModifier.UNKOWN)) {
            featureLocation = this.featureFactory.buildFeatureLocationWithUnknownEnd(startPosition, startLocationModifier);
        } else {
            throw new XMLParserException("Feature location is not specified correctly");
        }
        if (!Strings.isNullOrEmpty((String)xmlLocation.getSequence())) {
            featureLocation.setSequence(xmlLocation.getSequence());
        }
        feature.setFeatureLocation(featureLocation);
    }

    FeatureLocationModifier getLocationModifier(PositionType positionType) {
        FeatureLocationModifier locationModifier = FeatureLocationModifier.UNKOWN;
        String status = positionType.getStatus();
        if (status != null) {
            if ("uncertain".equalsIgnoreCase(status)) {
                locationModifier = FeatureLocationModifier.UNSURE;
            } else if ("less than".equalsIgnoreCase(status) || "greater than".equalsIgnoreCase(status)) {
                locationModifier = FeatureLocationModifier.OUTSIDE_KNOWN_SEQUENCE;
            } else if ("certain".equalsIgnoreCase(status)) {
                locationModifier = FeatureLocationModifier.EXACT;
            }
        }
        return locationModifier;
    }

    int getPosition(PositionType positionType) {
        int position = -1;
        if (positionType.getPosition() != null) {
            position = positionType.getPosition().intValue();
        }
        return position;
    }

    private void writePositionType(int position, FeatureLocationModifier locationModifier, String outsideStatus, PositionType positionType) {
        positionType.setPosition(BigInteger.valueOf(position));
        switch (locationModifier) {
            case UNSURE: {
                positionType.setStatus("uncertain");
                break;
            }
            case OUTSIDE_KNOWN_SEQUENCE: {
                positionType.setStatus(outsideStatus);
                break;
            }
        }
    }

    @Override
    public void featureToXmlBinding(Feature feature, FeatureType xmlFeature) {
        LocationType locationType = this.xmlUniprotFactory.createLocationType();
        FeatureLocation location = feature.getFeatureLocation();
        if (!Strings.isNullOrEmpty((String)location.getSequence())) {
            locationType.setSequence(location.getSequence());
        }
        try {
            if (this.locationIsExact(location)) {
                this.setExactPosition(locationType, location);
            } else if (this.locationIsUnsure(location)) {
                this.setUnsurePosition(locationType, location);
            } else if (this.locationIsUnknown(location)) {
                this.setUnknownPosition(locationType);
            } else {
                this.writeBeginElement(locationType, location);
                this.writeEndElement(locationType, location);
            }
        }
        catch (FieldUnavailableException e) {
            LOG.error(e.getMessage());
        }
        xmlFeature.setLocation(locationType);
    }

    private boolean locationIsUnknown(FeatureLocation location) {
        return location.getStartModifier().equals((Object)FeatureLocationModifier.UNKOWN) && location.getEndModifier().equals((Object)FeatureLocationModifier.UNKOWN);
    }

    private boolean locationIsUnsure(FeatureLocation location) {
        return (location.getStartModifier().equals((Object)FeatureLocationModifier.UNSURE) || location.getEndModifier().equals((Object)FeatureLocationModifier.UNSURE)) && location.getStart() == location.getEnd();
    }

    private boolean locationIsExact(FeatureLocation location) {
        return location.getStartModifier().equals((Object)FeatureLocationModifier.EXACT) && location.getEndModifier().equals((Object)FeatureLocationModifier.EXACT) && location.getStart() == location.getEnd();
    }

    private void setUnknownPosition(LocationType locationType) {
        PositionType positionType = this.xmlUniprotFactory.createPositionType();
        positionType.setStatus("unknown");
        locationType.setPosition(positionType);
    }

    private void setUnsurePosition(LocationType locationType, FeatureLocation location) {
        PositionType positionType = this.xmlUniprotFactory.createPositionType();
        positionType.setPosition(BigInteger.valueOf(location.getStart()));
        positionType.setStatus("uncertain");
        locationType.setPosition(positionType);
    }

    private void setExactPosition(LocationType locationType, FeatureLocation location) {
        PositionType positionType = this.xmlUniprotFactory.createPositionType();
        positionType.setPosition(BigInteger.valueOf(location.getStart()));
        locationType.setPosition(positionType);
    }

    private void writeEndElement(LocationType locationType, FeatureLocation location) {
        PositionType endPositionType = this.xmlUniprotFactory.createPositionType();
        if (location.getEndModifier().equals((Object)FeatureLocationModifier.UNKOWN)) {
            endPositionType.setStatus("unknown");
        } else {
            this.writePositionType(location.getEnd(), location.getEndModifier(), "greater than", endPositionType);
        }
        locationType.setEnd(endPositionType);
    }

    private void writeBeginElement(LocationType locationType, FeatureLocation location) {
        PositionType startPositionType = this.xmlUniprotFactory.createPositionType();
        if (location.getStartModifier().equals((Object)FeatureLocationModifier.UNKOWN)) {
            startPositionType.setStatus("unknown");
        } else {
            this.writePositionType(location.getStart(), location.getStartModifier(), "less than", startPositionType);
        }
        locationType.setBegin(startPositionType);
    }
}

