/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.evidence;

import java.math.BigInteger;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.util.EvidenceCodeGenerator;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SourceType;

public class EvidenceHandler
implements GenericHandler<Evidence, EvidenceType> {
    private static final String REF2 = "ref.";
    private static final String REF = "Ref.";
    private final ObjectFactory xmlUniprotFactory;
    private final UniProtFactory uniprotFactory;
    private final EvidenceFactory evidenceFactory;
    private final EvidenceCodeGenerator evidenceCodeGenerator = new EvidenceCodeGenerator();

    public EvidenceHandler() {
        this(new ObjectFactory(), DefaultUniProtFactory.getInstance());
    }

    public EvidenceHandler(ObjectFactory xmlUniprotFactory, UniProtFactory uniprotFactory) {
        this.xmlUniprotFactory = xmlUniprotFactory;
        this.uniprotFactory = uniprotFactory;
        this.evidenceFactory = this.uniprotFactory.buildEvidenceFactory();
    }

    @Override
    public Evidence fromXmlBinding(EvidenceType xmlObject) {
        Evidence evidence = this.evidenceFactory.buildEvidence();
        EvidenceCode evidenceCode = EvidenceCode.typeOf(xmlObject.getType());
        evidence.setEvidenceCode(evidenceCode);
        EvidenceCategory evidenceCategory = this.evidenceCodeGenerator.convertToEvidenceCategory(evidenceCode);
        evidence.setCategory(evidenceCategory);
        uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType evType = this.evidenceCodeGenerator.convertToEvidenceType(evidenceCode);
        boolean typeSetted = false;
        if (evType != uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.NOT_SPECIFIED) {
            evidence.setType(evType);
            typeSetted = true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(xmlObject.getType());
        if (xmlObject.getSource() != null) {
            if (xmlObject.getSource().getDbReference() != null) {
                DbReferenceType dbRef = xmlObject.getSource().getDbReference();
                if (!typeSetted) {
                    evidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.typeOf(dbRef.getType()));
                }
                evidence.setAttribute(this.evidenceFactory.buildEvidenceAttribute(dbRef.getId()));
                if (!xmlObject.getSource().getDbReference().getType().isEmpty() || !xmlObject.getSource().getDbReference().getId().isEmpty()) {
                    sb.append("|");
                    sb.append(dbRef.getType());
                    if (!dbRef.getId().isEmpty()) {
                        sb.append(":").append(dbRef.getId());
                    }
                }
            } else if (xmlObject.getSource().getRef() != null) {
                String attr = REF + xmlObject.getSource().getRef().toString();
                evidence.setAttribute(this.evidenceFactory.buildEvidenceAttribute(attr));
                sb.append("|").append(attr);
            }
        }
        EvidenceId evidenceId = this.evidenceFactory.buildEvidenceId(sb.toString());
        evidence.setEvidenceId(evidenceId);
        return evidence;
    }

    @Override
    public EvidenceType toXmlBinding(Evidence object) {
        EvidenceType xmlEvidence = this.xmlUniprotFactory.createEvidenceType();
        xmlEvidence.setType(object.getEvidenceCode().getCodeValue());
        SourceType sourceType = this.xmlUniprotFactory.createSourceType();
        String attribute = object.getAttribute().getValue();
        DbReferenceType dbRef = this.buildDbRefType(object, attribute);
        boolean hasSource = true;
        if (dbRef != null && !dbRef.getType().isEmpty()) {
            sourceType.setDbReference(dbRef);
        } else if (!attribute.isEmpty()) {
            String val = attribute.substring(4).trim();
            BigInteger bi = new BigInteger(val);
            sourceType.setRef(bi);
        } else {
            hasSource = false;
        }
        if (hasSource) {
            xmlEvidence.setSource(sourceType);
        }
        xmlEvidence.setKey(BigInteger.valueOf(1L));
        return xmlEvidence;
    }

    private DbReferenceType buildDbRefType(Evidence object, String attribute) {
        if (this.evidenceCodeGenerator.convertToEvidenceType(object.getEvidenceCode()) != uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.NOT_SPECIFIED) {
            if (attribute != null && (attribute.startsWith(REF) || attribute.startsWith(REF2))) {
                return null;
            }
            DbReferenceType dbRef = this.xmlUniprotFactory.createDbReferenceType();
            dbRef.setType(object.getEvidenceId().getTypeValue());
            dbRef.setId(object.getEvidenceId().getAttribute().getValue());
            return dbRef;
        }
        DbReferenceType dbRef = this.xmlUniprotFactory.createDbReferenceType();
        dbRef.setType(object.getType().getValue());
        dbRef.setId(attribute);
        return dbRef;
    }
}

