/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericXmlName;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public abstract class GenericNameHandler<T, S> {
    final ObjectFactory objectFactory;
    final UniProtFactory factory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final EcNumberHandler ecNumberHandler;

    GenericNameHandler(ObjectFactory objectFactory, UniProtFactory factory, EvidenceReferenceHandler evidenceReferenceHandler, EcNumberHandler ecNumberHandler) {
        this.objectFactory = objectFactory;
        this.factory = factory;
        this.ecNumberHandler = ecNumberHandler;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    public abstract T toXmlName(S var1);

    public abstract S fromXmlName(T var1);

    GenericXmlName populateXmlName(Name name) {
        if (name != null) {
            boolean touched = false;
            GenericXmlName genericXmlName = new GenericXmlName();
            for (Field field : name.getFields()) {
                List<Integer> evs;
                EvidencedStringType stringType = this.objectFactory.createEvidencedStringType();
                stringType.setValue(field.getValue());
                if (!field.getEvidenceIds().isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(field.getEvidenceIds())).isEmpty()) {
                    stringType.getEvidence().addAll(evs);
                }
                switch (field.getType()) {
                    case FULL: {
                        genericXmlName.setFullName(stringType);
                        touched = true;
                        break;
                    }
                    case SHORT: {
                        genericXmlName.getShortNameList().add(stringType);
                        touched = true;
                        break;
                    }
                    case EC: {
                        genericXmlName.addEcNumber(stringType);
                        this.ecNumberHandler.add(field);
                        touched = true;
                        break;
                    }
                    case BIOTECH: {
                        genericXmlName.setBiotechName(stringType);
                        touched = true;
                        break;
                    }
                    case ALLERGEN: {
                        genericXmlName.setAllergenName(stringType);
                        touched = true;
                        break;
                    }
                    case CD_ANTIGEN: {
                        genericXmlName.getCdAntigenName().add(stringType);
                        touched = true;
                        break;
                    }
                    case INN: {
                        genericXmlName.getInnName().add(stringType);
                        touched = true;
                        break;
                    }
                }
            }
            return touched ? genericXmlName : null;
        }
        return null;
    }

    Name populateName(GenericXmlName xmlName) {
        if (xmlName != null) {
            List<EvidencedStringType> xmlInnList;
            List<EvidencedStringType> xmlAntigeneList;
            EvidencedStringType xmlBiotechName;
            EvidencedStringType xmlAllergenName;
            List<EvidencedStringType> ecNumbers;
            List<EvidencedStringType> xmlShortNames;
            ArrayList<Field> fieldList = new ArrayList<Field>();
            EvidencedStringType xmlFullName = xmlName.getFullName();
            if (xmlFullName != null) {
                fieldList.add(this.convertXmlToField(xmlFullName, FieldType.FULL));
            }
            if ((xmlShortNames = xmlName.getShortNameList()) != null) {
                fieldList.addAll(this.convertXmlListToFields(xmlShortNames, FieldType.SHORT));
            }
            if ((ecNumbers = xmlName.getEcNumberList()) != null) {
                fieldList.addAll(this.convertXmlListToFields(ecNumbers, FieldType.EC));
            }
            if ((xmlAllergenName = xmlName.getAllergenName()) != null) {
                fieldList.add(this.convertXmlToField(xmlAllergenName, FieldType.ALLERGEN));
            }
            if ((xmlBiotechName = xmlName.getBiotechName()) != null) {
                fieldList.add(this.convertXmlToField(xmlBiotechName, FieldType.BIOTECH));
            }
            if ((xmlAntigeneList = xmlName.getCdAntigenName()) != null) {
                fieldList.addAll(this.convertXmlListToFields(xmlAntigeneList, FieldType.CD_ANTIGEN));
            }
            if ((xmlInnList = xmlName.getInnName()) != null) {
                fieldList.addAll(this.convertXmlListToFields(xmlInnList, FieldType.INN));
            }
            if (!fieldList.isEmpty()) {
                Name name = this.factory.buildName();
                name.setFields(fieldList);
                return name;
            }
        }
        return null;
    }

    private Field convertXmlToField(EvidencedStringType xmlField, FieldType fieldType) {
        Field field = this.factory.buildField();
        field.setValue(xmlField.getValue());
        field.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(xmlField.getEvidence()));
        field.setType(fieldType);
        return field;
    }

    private List<Field> convertXmlListToFields(List<EvidencedStringType> xmlFieldList, FieldType fieldType) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (EvidencedStringType xmlField : xmlFieldList) {
            fieldList.add(this.convertXmlToField(xmlField, fieldType));
        }
        return fieldList;
    }
}

