/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericSectionHandler;

public class ContainsSectionHandler
extends GenericSectionHandler<ProteinType.Component> {
    public ContainsSectionHandler(ObjectFactory objectFactory, UniProtFactory factory, Map<NameType, GenericNameHandler> nameHandlerMap) {
        super(objectFactory, factory, nameHandlerMap);
    }

    @Override
    public ProteinType.Component toXmlSection(Section section) {
        ProteinType proteinType = this.populateProteinType(section);
        return this.convertToComponent(proteinType);
    }

    private ProteinType.Component convertToComponent(ProteinType proteinType) {
        if (proteinType != null) {
            List<EvidencedStringType> innNameList;
            List<EvidencedStringType> cdAntigeneNameList;
            List<ProteinType.SubmittedName> subNameList;
            ProteinType.Component component = this.objectFactory.createProteinTypeComponent();
            component.setRecommendedName(proteinType.getRecommendedName());
            component.setAllergenName(proteinType.getAllergenName());
            component.setBiotechName(proteinType.getBiotechName());
            List<ProteinType.AlternativeName> altNameList = proteinType.getAlternativeName();
            if (!altNameList.isEmpty()) {
                component.getAlternativeName().addAll(altNameList);
            }
            if (!(subNameList = proteinType.getSubmittedName()).isEmpty()) {
                component.getSubmittedName().addAll(subNameList);
            }
            if (!(cdAntigeneNameList = proteinType.getCdAntigenName()).isEmpty()) {
                component.getCdAntigenName().addAll(cdAntigeneNameList);
            }
            if (!(innNameList = proteinType.getInnName()).isEmpty()) {
                component.getInnName().addAll(innNameList);
            }
            return component;
        }
        return null;
    }

    @Override
    public Section fromXmlSection(ProteinType.Component component) {
        if (component != null) {
            return this.populateSection(this.convertToProteinType(component));
        }
        return null;
    }

    private ProteinType convertToProteinType(ProteinType.Component component) {
        if (component != null) {
            List<EvidencedStringType> innNameList;
            List<EvidencedStringType> cdAntigeneNameList;
            List<ProteinType.SubmittedName> subNameList;
            ProteinType proteinType = this.objectFactory.createProteinType();
            proteinType.setRecommendedName(component.getRecommendedName());
            proteinType.setAllergenName(component.getAllergenName());
            proteinType.setBiotechName(component.getBiotechName());
            List<ProteinType.AlternativeName> altNameList = component.getAlternativeName();
            if (!altNameList.isEmpty()) {
                proteinType.getAlternativeName().addAll(altNameList);
            }
            if (!(subNameList = component.getSubmittedName()).isEmpty()) {
                proteinType.getSubmittedName().addAll(subNameList);
            }
            if (!(cdAntigeneNameList = proteinType.getCdAntigenName()).isEmpty()) {
                proteinType.getCdAntigenName().addAll(cdAntigeneNameList);
            }
            if (!(innNameList = component.getInnName()).isEmpty()) {
                proteinType.getInnName().addAll(innNameList);
            }
            return proteinType;
        }
        return null;
    }
}

