/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment.subcell;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocation;
import uk.ac.ebi.kraken.xml.uniprot.comment.subcell.SubcellLocationImpl;

public class SubcellLocationReader {
    private static final Logger LOG = LoggerFactory.getLogger(SubcellLocationReader.class);
    private final String filename;
    private static String ID = "ID";
    private static String END = "//";
    private static String DEFAULT_FILE = "https://ebi1.uniprot.org/docs/subcell.txt";

    public SubcellLocationReader() {
        this.filename = DEFAULT_FILE;
    }

    public SubcellLocationReader(String filename) {
        this.filename = Strings.isNullOrEmpty((String)filename) ? DEFAULT_FILE : filename;
    }

    public List<SubcellLocation> read() {
        ArrayList<SubcellLocation> locations = new ArrayList<SubcellLocation>();
        try {
            String line;
            BufferedReader reader = this.getBufferedReader();
            ArrayList<String> entry = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(ID)) continue;
                entry.add(line);
                break;
            }
            while ((line = reader.readLine()) != null) {
                entry.add(line);
                if (!line.equals(END)) continue;
                Optional<SubcellLocation> opSL = this.parse(entry);
                if (opSL.isPresent()) {
                    locations.add(opSL.get());
                }
                entry.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locations;
    }

    private Optional<SubcellLocation> parse(List<String> entry) {
        for (String line : entry) {
            if (!line.startsWith("SL")) continue;
            String val = line.substring(5, line.length() - 1);
            return Optional.of(SubcellLocationImpl.of(val));
        }
        return Optional.empty();
    }

    private BufferedReader getBufferedReader() {
        try {
            URL url = new URL(this.filename);
            URLConnection con = url.openConnection(Proxy.NO_PROXY);
            InputStream is = con.getInputStream();
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (IOException e) {
            LOG.debug("Failed to create inputStream: " + this.filename);
            try {
                LOG.debug("Use file directly: " + this.filename);
                return new BufferedReader(new FileReader(this.filename));
            }
            catch (IOException e2) {
                throw new RuntimeException("Cannot read file: " + this.filename + " " + e2.getMessage(), e2);
            }
        }
    }
}

