/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalDirectionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PhysiologicalReactionType;
import uk.ac.ebi.kraken.xml.uniprot.comment.ReactionReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class PhysiologicalReactionHandler
implements GenericHandler<PhysiologicalReaction, PhysiologicalReactionType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evRefHandler;
    private final ReactionReferenceHandler referenceHandler;

    public PhysiologicalReactionHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceRefHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evRefHandler = evidenceRefHandler;
        this.referenceHandler = new ReactionReferenceHandler(commentFactory, objectFactory);
    }

    @Override
    public PhysiologicalReaction fromXmlBinding(PhysiologicalReactionType xmlObject) {
        PhysiologicalReaction physioReaction = this.commentFactory.buildPhysiologicalReaction();
        physioReaction.setDirectionType(PhysiologicalDirectionType.typeOf(xmlObject.getDirection()));
        physioReaction.setReactionReference(this.referenceHandler.fromXmlBinding(xmlObject.getDbReference()));
        if (!xmlObject.getEvidence().isEmpty()) {
            physioReaction.getEvidenceIds().addAll(this.evRefHandler.parseEvidenceIDs(xmlObject.getEvidence()));
        }
        return physioReaction;
    }

    @Override
    public PhysiologicalReactionType toXmlBinding(PhysiologicalReaction object) {
        List<Integer> evs;
        PhysiologicalReactionType physioReactionType = this.objectFactory.createPhysiologicalReactionType();
        physioReactionType.setDirection(object.getDirectionType().toDisplayName());
        physioReactionType.setDbReference(this.referenceHandler.toXmlBinding(object.getReactionReference()));
        List<EvidenceId> evidenceIds = object.getEvidenceIds();
        if (evidenceIds != null && !evidenceIds.isEmpty() && !(evs = this.evRefHandler.writeEvidenceIDs(evidenceIds)).isEmpty()) {
            physioReactionType.getEvidence().addAll(evs);
        }
        return physioReactionType;
    }
}

