/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionGeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.InteractantType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class InteractionHandler
implements GenericHandler<List<Interaction>, CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;

    public InteractionHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = referenceHandler;
    }

    @Override
    public List<Interaction> fromXmlBinding(CommentType xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        Interaction interaction = this.commentFactory.buildInteraction();
        List<InteractantType> actTypes = xmlObject.getInteractant();
        assert (actTypes.size() == 2);
        InteractantType firstAct = actTypes.get(0);
        InteractantType secondAct = actTypes.get(1);
        if (firstAct.getLabel() != null && !firstAct.getLabel().isEmpty()) {
            InteractantType temp = firstAct;
            firstAct = secondAct;
            secondAct = temp;
        }
        if (xmlObject.isOrganismsDiffer().booleanValue()) {
            interaction.setInteractionType(InteractionType.XENO);
        } else {
            interaction.setInteractionType(InteractionType.BINARY);
        }
        if (!xmlObject.getEvidence().isEmpty()) {
            interaction.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(xmlObject.getEvidence()));
        }
        interaction.setFirstInteractor(this.commentFactory.buildIntActAccession(firstAct.getIntactId()));
        interaction.setFirstInteractant(this.commentFactory.buildInteractorUniProtId(firstAct.getId()));
        interaction.setSecondInteractor(this.commentFactory.buildIntActAccession(secondAct.getIntactId()));
        interaction.setSecondInteractant(this.commentFactory.buildInteractorUniProtId(secondAct.getId()));
        if (secondAct.getLabel() != null) {
            interaction.setInteractionGeneName(this.commentFactory.buildInteractionGeneName(secondAct.getLabel()));
        }
        if (secondAct.getDbReference() != null) {
            interaction.setSecondInteractantParent(this.commentFactory.buildInteractorUniProtId(secondAct.getDbReference().getId()));
        }
        interaction.setNumberOfExperiments(xmlObject.getExperiments());
        return Arrays.asList(interaction);
    }

    @Override
    public CommentType toXmlBinding(List<Interaction> objects) {
        if (objects == null) {
            return null;
        }
        CommentType commentType = this.objectFactory.createCommentType();
        commentType.setType("interaction");
        for (Interaction object : objects) {
            List<Integer> evs;
            String firstInteract = object.getFirstInteractor().getValue();
            InteractantType firstactantType = this.objectFactory.createInteractantType();
            firstactantType.setIntactId(firstInteract);
            commentType.getInteractant().add(firstactantType);
            InteractantType secondactantType = this.objectFactory.createInteractantType();
            String secondInteract = object.getSecondInteractor().getValue();
            secondactantType.setIntactId(secondInteract);
            commentType.getInteractant().add(secondactantType);
            InteractionType type = object.getInteractionType();
            if (type == InteractionType.XENO) {
                commentType.setOrganismsDiffer(true);
            } else {
                commentType.setOrganismsDiffer(false);
            }
            firstactantType.setId(object.getFirstInteractant().getValue());
            secondactantType.setId(object.getSecondInteractant().getValue());
            InteractionGeneName interactionGeneName = object.getInteractionGeneName();
            if (interactionGeneName != null && !Strings.isNullOrEmpty((String)interactionGeneName.getValue())) {
                secondactantType.setLabel(interactionGeneName.getValue());
            }
            if (object.getSecondInteractantParent() != null && !Strings.isNullOrEmpty((String)object.getSecondInteractantParent().getValue())) {
                DbReferenceType xmlReference = this.objectFactory.createDbReferenceType();
                xmlReference.setType("UniProtKB");
                xmlReference.setId(object.getSecondInteractantParent().getValue());
                secondactantType.setDbReference(xmlReference);
            }
            commentType.setExperiments(object.getNumberOfExperiments());
            if (object.getEvidenceIds().isEmpty() || (evs = this.evidenceReferenceHandler.writeEvidenceIDs(object.getEvidenceIds())).isEmpty()) continue;
            commentType.getEvidence().addAll(evs);
        }
        return commentType;
    }
}

